/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query.impl;

import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.clarkparsia.pellet.api.query.OrderCondition;
import com.clarkparsia.pellet.api.query.Query;
import com.clarkparsia.pellet.api.query.SPARQLSerializer;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import com.clarkparsia.pellet.util.terms.TermCollector;
import com.complexible.common.base.Options;
import com.complexible.common.hash.HashCodeUtil;
import com.complexible.common.util.PrefixMapping;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractQueryImpl<ReturnType>
implements Query<ReturnType> {
    private QueryAtom body;
    private final LinkedHashSet<String> graphURIs = Sets.newLinkedHashSet();
    private final LinkedHashSet<String> namedGraphURIs = Sets.newLinkedHashSet();
    private Long limit;
    private Long offset;
    private final Collection<OrderCondition> orderBy = Lists.newArrayList();

    @Override
    public QueryAtom getBody() {
        return this.body;
    }

    @Override
    public Set<Variable> getVariables() {
        return TermCollector.collect((Term)this.body, Variable.class);
    }

    @Override
    public void setBody(QueryAtom body) {
        this.body = body;
    }

    @Override
    public Set<String> getGraphURIs() {
        return this.graphURIs;
    }

    @Override
    public void addGraphURI(String uri) {
        this.graphURIs.add(uri);
    }

    @Override
    public void removeGraphURI(String uri) {
        this.graphURIs.remove(uri);
    }

    @Override
    public Set<String> getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    @Override
    public void addNamedGraphURI(String uri) {
        this.namedGraphURIs.add(uri);
    }

    @Override
    public void removeNamedGraphURI(String uri) {
        this.namedGraphURIs.remove(uri);
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }

    @Override
    public void setLimit(Long limit) {
        this.limit = limit;
    }

    @Override
    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @Override
    public void addOrderBy(OrderCondition condition) {
        this.orderBy.add(condition);
    }

    @Override
    public Collection<OrderCondition> getOrderBy() {
        return this.orderBy;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = HashCodeUtil.hash((int)hashCode, (Object)this.body);
        hashCode = HashCodeUtil.hash((int)hashCode, this.graphURIs);
        hashCode = HashCodeUtil.hash((int)hashCode, this.namedGraphURIs);
        hashCode = HashCodeUtil.hash((int)hashCode, (Object)this.limit);
        hashCode = HashCodeUtil.hash((int)hashCode, (Object)this.offset);
        hashCode = HashCodeUtil.hash((int)hashCode, this.orderBy);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Query) {
            Query other = (Query)obj;
            return Objects.equal((Object)this.body, (Object)other.getBody()) && this.graphURIs.equals(other.getGraphURIs()) && this.namedGraphURIs.equals(other.getNamedGraphURIs()) && Objects.equal((Object)this.limit, (Object)other.getLimit()) && Objects.equal((Object)this.offset, (Object)other.getOffset()) && this.orderBy.equals(other.getOrderBy());
        }
        return false;
    }

    @Override
    public String toString(boolean useSPARQL11) {
        SPARQLSerializer ss = new SPARQLSerializer(Options.of(SPARQLSerializer.SPARQL11, (Object)useSPARQL11));
        return ss.serialize(this);
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(PrefixMapping prefixes) {
        SPARQLSerializer ss = new SPARQLSerializer(Options.of(OntologyWriterOptions.PREFIX_MAPPING, (Object)prefixes));
        return ss.serialize(this);
    }
}

