/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query.impl;

import com.clarkparsia.pellet.api.query.AskQuery;
import com.clarkparsia.pellet.api.query.Binding;
import com.clarkparsia.pellet.api.query.ConstructQuery;
import com.clarkparsia.pellet.api.query.DescribeQuery;
import com.clarkparsia.pellet.api.query.Query;
import com.clarkparsia.pellet.api.query.QueryEngine;
import com.clarkparsia.pellet.api.query.QueryVisitor;
import com.clarkparsia.pellet.api.query.ResultSet;
import com.clarkparsia.pellet.api.query.SelectQuery;
import com.clarkparsia.pellet.api.query.impl.ResultSetStream;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import com.clarkparsia.pellet.util.Substitution;
import com.clarkparsia.pellet.util.terms.TermCollector;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractQueryEngine
implements QueryEngine,
QueryVisitor<Object> {
    @Override
    public <ResultType> ResultType execute(Query<ResultType> query) {
        return (ResultType)query.accept(this);
    }

    @Override
    public Boolean visit(AskQuery query) {
        Iterator<Binding> results = this.execute(query, query.getVariables(), false);
        return results.hasNext();
    }

    @Override
    public Iterator<Axiom> visit(ConstructQuery query) {
        Iterator<Binding> results = this.execute(query, query.getVariables(), false);
        final Set<Axiom> template = query.getConstructTemplate();
        Function<Binding, Iterator<Axiom>> transform = new Function<Binding, Iterator<Axiom>>(){

            public Iterator<Axiom> apply(Binding binding) {
                return Iterators.transform(template.iterator(), Substitution.createUniformSubstitution(binding));
            }
        };
        return Iterators.concat((Iterator)Iterators.transform(results, (Function)transform));
    }

    @Override
    public Iterator<Axiom> visit(DescribeQuery query) {
        QueryAtom body = query.getBody();
        if (body == null) {
            Set<Entity> entities = query.getDescribeEntities();
            return Iterators.concat((Iterator)Iterators.transform(entities.iterator(), (Function)new Function<Entity, Iterator<Axiom>>(){

                public Iterator<Axiom> apply(Entity entity) {
                    return entity.isVariable() ? ImmutableSet.of().iterator() : AbstractQueryEngine.this.describe((NamedEntity)entity);
                }
            }));
        }
        ArrayList entities = Lists.newArrayList(TermCollector.collect(query.getDescribeEntities(), NamedEntity.class));
        Iterator<Binding> results = this.execute(query, query.getVariables(), false);
        while (results.hasNext()) {
            Binding binding = results.next();
            for (Entity entity : query.getDescribeEntities()) {
                Term value;
                if (!entity.isVariable() || !((value = binding.apply((Variable)entity)) instanceof NamedEntity)) continue;
                entities.add((NamedEntity)value);
            }
        }
        return Iterators.concat((Iterator)Iterators.transform(entities.iterator(), (Function)new Function<Entity, Iterator<Axiom>>(){

            public Iterator<Axiom> apply(Entity entity) {
                return entity.isVariable() ? ImmutableSet.of().iterator() : AbstractQueryEngine.this.describe((NamedEntity)entity);
            }
        }));
    }

    protected Iterator<Axiom> describe(NamedEntity entity) {
        return ImmutableSet.of().iterator();
    }

    @Override
    public ResultSet visit(SelectQuery query) {
        Iterator<Binding> results = this.execute(query, query.getSelectVariables(), query.isDistinct());
        ImmutableSet selectVars = ImmutableSet.copyOf(query.isSelectAll() ? query.getVariables() : query.getSelectVariables());
        return new ResultSetStream((Set<Variable>)selectVars, results);
    }

    protected abstract Iterator<Binding> execute(Query<?> var1, Set<Variable> var2, boolean var3);
}

