/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query;

import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.clarkparsia.pellet.api.query.AskQuery;
import com.clarkparsia.pellet.api.query.ConstructQuery;
import com.clarkparsia.pellet.api.query.DescribeQuery;
import com.clarkparsia.pellet.api.query.OrderCondition;
import com.clarkparsia.pellet.api.query.Query;
import com.clarkparsia.pellet.api.query.QueryVisitorVoid;
import com.clarkparsia.pellet.api.query.SelectQuery;
import com.clarkparsia.pellet.api.term.NamedTerm;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.FunctionAtomRewriter;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.function.BindAtom;
import com.clarkparsia.pellet.api.term.function.Expression;
import com.clarkparsia.pellet.api.term.function.FilterAtom;
import com.clarkparsia.pellet.api.term.function.FunctionEval;
import com.clarkparsia.pellet.api.term.query.DatatypeAtom;
import com.clarkparsia.pellet.api.term.query.QueryAnd;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import com.clarkparsia.pellet.api.term.query.QueryNamedGraph;
import com.clarkparsia.pellet.api.term.query.QueryNot;
import com.clarkparsia.pellet.api.term.query.QueryOptional;
import com.clarkparsia.pellet.api.term.query.QueryOr;
import com.clarkparsia.pellet.api.term.rule.Rule;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitorVoid;
import com.clarkparsia.pellet.api.term.visitor.RecursiveTermVisitorVoid;
import com.clarkparsia.pellet.rdf.RDFAxiomWriter;
import com.clarkparsia.pellet.rdf.RDFAxiomWriters;
import com.clarkparsia.pellet.rdf.TurtleOutputFactory;
import com.clarkparsia.pellet.rdf.TurtleRDFOutput;
import com.clarkparsia.pellet.util.terms.TermCollector;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.io.block.BlockMarker;
import com.complexible.common.io.block.BlockSpec;
import com.complexible.common.io.block.BlockWriter;
import com.complexible.common.io.block.Bracket;
import com.complexible.common.io.block.TextBlockWriter;
import com.complexible.common.util.PrefixMapping;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SPARQLSerializer {
    public static final Option<Boolean> COMPACT_NEGATION = Option.create((String)(SPARQLSerializer.class.getName() + ".COMPACT_NEGATION"), (Object)Boolean.TRUE);
    public static final Option<Function<String, String>> NEGATION_VAR_SERIALIZER = Option.create((String)(SPARQLSerializer.class.getName() + ".NEGATION_VAR_SERIALIZER"));
    public static final Option<Boolean> SPARQL11 = Option.create((String)(SPARQLSerializer.class.getName() + ".SPARQL11"), (Object)Boolean.FALSE);
    private static final FunctionAtomRewriter REWRITER = new FunctionAtomRewriter();
    private static final BlockSpec BLOCK = BlockSpec.INDENTED.copy().newLineAfterBegin(true).newLineAfterEnd(true).marker((BlockMarker)Bracket.CURLY);
    private static final BlockSpec WHERE = BLOCK.copy().title("WHERE");
    private static final Map<com.clarkparsia.pellet.api.term.function.Function, String> INFIX_SYMBOLS = ImmutableMap.builder().put((Object)Functions.EQUAL, (Object)"=").put((Object)Functions.NOT_EQUAL, (Object)"!=").put((Object)Functions.LESS_THAN, (Object)"<").put((Object)Functions.LESS_THAN_OR_EQUAL, (Object)"<=").put((Object)Functions.GREATER_THAN, (Object)">").put((Object)Functions.GREATER_THAN_OR_EQUAL, (Object)">=").put((Object)Functions.ADD, (Object)"+").put((Object)Functions.SUBTRACT, (Object)"-").put((Object)Functions.MULTIPLY, (Object)"*").put((Object)Functions.DIVIDE, (Object)"/").put((Object)Functions.AND, (Object)"&&").put((Object)Functions.OR, (Object)"||").build();
    private static final Map<com.clarkparsia.pellet.api.term.function.Function, String> SPARQL_NAMES = ImmutableMap.builder().put((Object)Functions.ABS, (Object)"abs").put((Object)Functions.CEILING, (Object)"ceil").put((Object)Functions.CONTAINS, (Object)"contains").put((Object)Functions.ENDS_WITH, (Object)"strends").put((Object)Functions.FLOOR, (Object)"floor").put((Object)Functions.LOWER_CASE, (Object)"lcase").put((Object)Functions.MATCHES, (Object)"regex").put((Object)Functions.REPLACE, (Object)"replace").put((Object)Functions.ROUND, (Object)"round").put((Object)Functions.STARTS_WITH, (Object)"strstarts").put((Object)Functions.STRING_CONCAT, (Object)"concat").put((Object)Functions.STRING_LENGTH, (Object)"strlen").put((Object)Functions.SUBSTRING, (Object)"substr").put((Object)Functions.SUBSTRING_AFTER, (Object)"strafter").put((Object)Functions.SUBSTRING_BEFORE, (Object)"strbefore").put((Object)Functions.UPPER_CASE, (Object)"ucase").build();
    private static final Predicate<Expression> REQUIRES_NEWLINE = new TypeSafePredicate<Expression, FunctionEval>(FunctionEval.class, false){

        @Override
        public boolean applyTypeSafe(FunctionEval arg) {
            com.clarkparsia.pellet.api.term.function.Function func = arg.getFunction();
            return func.equals(Functions.AND) || func.equals(Functions.OR);
        }
    };
    private static final Predicate<Expression> REQUIRES_PAREN = new TypeSafePredicate<Expression, FunctionEval>(FunctionEval.class, false){

        @Override
        public boolean applyTypeSafe(FunctionEval arg) {
            com.clarkparsia.pellet.api.term.function.Function func = arg.getFunction();
            return INFIX_SYMBOLS.containsKey(func);
        }
    };
    private QueryVisitorVoid header = new QueryVisitorVoid(){

        @Override
        public void visit(SelectQuery query) {
            SPARQLSerializer.this.out.append((CharSequence)"SELECT ");
            if (query.isDistinct()) {
                SPARQLSerializer.this.out.append((CharSequence)"DISTINCT ");
            }
            if (query.isSelectAll()) {
                SPARQLSerializer.this.out.append((CharSequence)"*");
            } else {
                SPARQLSerializer.this.writeValues(query.getSelectVariables());
            }
            SPARQLSerializer.this.out.println();
            this.serializeDatasetClause(query);
            SPARQLSerializer.this.out.beginBlock(WHERE);
        }

        @Override
        public void visit(DescribeQuery query) {
            SPARQLSerializer.this.out.append((CharSequence)"DESCRIBE ");
            if (query.isDescribeAll()) {
                SPARQLSerializer.this.out.append((CharSequence)"*");
            } else {
                SPARQLSerializer.this.writeValues(query.getDescribeEntities());
            }
            SPARQLSerializer.this.out.println();
            this.serializeDatasetClause(query);
            if (query.getBody() != null) {
                SPARQLSerializer.this.out.beginBlock(WHERE);
            }
        }

        @Override
        public void visit(ConstructQuery query) {
            SPARQLSerializer.this.out.print("CONSTRUCT ");
            SPARQLSerializer.this.out.beginBlock(BLOCK);
            if (query.getConstructTemplate() != null) {
                SPARQLSerializer.this.writeAxioms(query.getConstructTemplate());
            }
            SPARQLSerializer.this.out.println();
            SPARQLSerializer.this.out.endBlock();
            this.serializeDatasetClause(query);
            SPARQLSerializer.this.out.beginBlock(WHERE);
        }

        @Override
        public void visit(AskQuery query) {
            SPARQLSerializer.this.out.println("ASK");
            this.serializeDatasetClause(query);
            SPARQLSerializer.this.out.beginBlock(WHERE);
        }

        private void serializeDatasetClause(Query<?> query) {
            for (String graphURI : query.getGraphURIs()) {
                SPARQLSerializer.this.out.append((CharSequence)"FROM <").append(graphURI).append(">");
                SPARQLSerializer.this.out.println();
            }
            for (String namedGraphURI : query.getNamedGraphURIs()) {
                SPARQLSerializer.this.out.append((CharSequence)"FROM NAMED <").append(namedGraphURI).append(">");
                SPARQLSerializer.this.out.println();
            }
        }
    };
    private QueryVisitorVoid footer = new QueryVisitorVoid(){

        @Override
        public void visit(SelectQuery query) {
            SPARQLSerializer.this.out.endBlock();
            if (!query.getOrderBy().isEmpty()) {
                SPARQLSerializer.this.out.append((CharSequence)"ORDER BY ");
                SPARQLSerializer.this.writeOrderConditions(query.getOrderBy());
                SPARQLSerializer.this.out.println();
            }
            if (query.getOffset() != null) {
                SPARQLSerializer.this.out.append((CharSequence)"OFFSET ");
                SPARQLSerializer.this.out.print((Object)query.getOffset());
                SPARQLSerializer.this.out.println();
            }
            if (query.getLimit() != null) {
                SPARQLSerializer.this.out.append((CharSequence)"LIMIT ");
                SPARQLSerializer.this.out.print((Object)query.getLimit());
                SPARQLSerializer.this.out.println();
            }
        }

        @Override
        public void visit(DescribeQuery query) {
            if (query.getBody() != null) {
                SPARQLSerializer.this.out.println();
                SPARQLSerializer.this.out.endBlock();
            }
        }

        @Override
        public void visit(ConstructQuery query) {
            SPARQLSerializer.this.out.endBlock();
        }

        @Override
        public void visit(AskQuery query) {
            SPARQLSerializer.this.out.endBlock();
        }
    };
    private BaseTermVisitorVoid atomWriter = new BaseTermVisitorVoid(){

        @Override
        public void defaultVisit(Term term) {
            SPARQLSerializer.this.writeAxiom(term);
        }

        @Override
        public void visit(QueryAnd and) {
            for (QueryAtom atom : and) {
                atom.accept(this);
            }
        }

        @Override
        public void visit(QueryOptional optional) {
            SPARQLSerializer.this.out.print("OPTIONAL ");
            SPARQLSerializer.this.out.beginBlock(BLOCK);
            optional.getArg().accept(this);
            SPARQLSerializer.this.out.endBlock();
        }

        @Override
        public void visit(QueryNamedGraph query) {
            SPARQLSerializer.this.out.append((CharSequence)"GRAPH ");
            SPARQLSerializer.this.writeEntity(query.getGraph());
            SPARQLSerializer.this.out.printSpace();
            SPARQLSerializer.this.out.beginBlock(BLOCK);
            query.getArg().accept(this);
            SPARQLSerializer.this.out.endBlock();
        }

        @Override
        public void visit(QueryNot not) {
            QueryAtom notAtom = not.getArg();
            if (notAtom instanceof DatatypeAtom) {
                FilterAtom result = REWRITER.rewrite((DatatypeAtom)notAtom, false);
                if (result != null) {
                    result.accept(this);
                }
            } else if (SPARQLSerializer.this.isSPARQL11()) {
                SPARQLSerializer.this.out.print("FILTER NOT EXISTS ");
                SPARQLSerializer.this.out.beginBlock(BLOCK);
                notAtom.accept(this);
                SPARQLSerializer.this.out.endBlock();
            } else {
                NamedTerm safeVar = null;
                if (SPARQLSerializer.this.isCompactQuery()) {
                    Set<Variable> vars = TermCollector.collect((Term)notAtom, Variable.class);
                    for (Variable var : vars) {
                        if (!SPARQLSerializer.this.isSafe(var, notAtom)) continue;
                        safeVar = var;
                        break;
                    }
                }
                String notVar = safeVar != null ? safeVar.getName() : "negationVar" + SPARQLSerializer.this.negationCount++;
                SPARQLSerializer.this.out.print("OPTIONAL ");
                SPARQLSerializer.this.out.beginBlock(BLOCK);
                notAtom.accept(this);
                if (safeVar == null) {
                    if (SPARQLSerializer.this.negationVarSerializer != null) {
                        SPARQLSerializer.this.out.append((CharSequence)SPARQLSerializer.this.negationVarSerializer.apply((Object)notVar));
                    } else {
                        SPARQLSerializer.this.writeAxiom(TermFactory.individualVariable(notVar).type(Classes.THING));
                    }
                }
                SPARQLSerializer.this.out.endBlock();
                SPARQLSerializer.this.out.println("FILTER (!bound(?" + notVar + "))");
            }
        }

        @Override
        public void visit(QueryOr union) {
            Iterator atoms = union.iterator();
            while (atoms.hasNext()) {
                QueryAtom atom = (QueryAtom)atoms.next();
                SPARQLSerializer.this.out.beginBlock(BLOCK);
                atom.accept(this);
                SPARQLSerializer.this.out.endBlock();
                if (!atoms.hasNext()) continue;
                SPARQLSerializer.this.out.println("UNION");
            }
        }

        @Override
        public void visit(FilterAtom atom) {
            SPARQLSerializer.this.out.append((CharSequence)"FILTER (");
            SPARQLSerializer.this.writeFunctionArg(atom.getValue());
            SPARQLSerializer.this.out.println(")");
        }

        @Override
        public void visit(BindAtom atom) {
            SPARQLSerializer.this.out.append((CharSequence)"BIND (");
            SPARQLSerializer.this.writeFunctionArg(atom.getValue());
            SPARQLSerializer.this.out.append((CharSequence)" AS ");
            SPARQLSerializer.this.writeFunctionArg(atom.getVar());
            SPARQLSerializer.this.out.println(")");
        }

        @Override
        public void visit(DatatypeAtom atom) {
            FilterAtom result = REWRITER.rewrite(atom);
            if (result != null) {
                result.accept(this);
            }
        }
    };
    private final Options options;
    private BlockWriter out;
    private RDFAxiomWriter axiomWriter;
    private ReferenceCounter referenceCounter;
    private int negationCount;
    private Function<String, String> negationVarSerializer = null;
    private PrefixMapping prefixes;
    private TurtleOutputFactory turtle;

    public SPARQLSerializer(Options options) {
        this.options = options;
        this.prefixes = options.contains(OntologyWriterOptions.PREFIX_MAPPING) ? (PrefixMapping)options.get(OntologyWriterOptions.PREFIX_MAPPING) : new PrefixMapping(false);
        this.turtle = new TurtleOutputFactory(this.prefixes);
        this.axiomWriter = RDFAxiomWriters.create(Options.of(OntologyWriterOptions.QUERY_MODE, (Object)Boolean.TRUE));
    }

    private boolean isCompactQuery() {
        return this.options.is(COMPACT_NEGATION);
    }

    private boolean isSPARQL11() {
        return this.options.is(SPARQL11);
    }

    public String serialize(Query<?> query) {
        StringWriter sb = new StringWriter();
        this.serialize(query, (Writer)sb);
        return sb.toString();
    }

    public void serialize(Query<?> query, Writer writer) {
        this.out = new TextBlockWriter(writer);
        this.negationVarSerializer = (Function)this.options.get(NEGATION_VAR_SERIALIZER);
        this.writePrefixes();
        query.accept(this.header);
        QueryAtom body = query.getBody();
        this.writeQueryBody(body);
        query.accept(this.footer);
    }

    private void writePrefixes() {
        for (String prefix : this.prefixes.getPrefixes()) {
            this.out.print("PREFIX ");
            this.out.print(prefix);
            this.out.print(": <");
            this.out.print(this.prefixes.getNamespace(prefix));
            this.out.println(">");
        }
        if (!this.prefixes.getPrefixes().isEmpty()) {
            this.out.println();
        }
    }

    public String serialize(Rule rule) {
        StringWriter sb = new StringWriter();
        this.serialize(rule, (Writer)sb);
        return sb.toString();
    }

    public void serialize(Rule rule, Writer writer) {
        this.out = new TextBlockWriter(writer);
        this.negationVarSerializer = (Function)this.options.get(NEGATION_VAR_SERIALIZER);
        this.out.print("IF ");
        this.out.beginBlock(BLOCK);
        this.writeQueryBody(TermFactory.queryAnd(rule.getBody()));
        this.out.endBlock();
        this.out.print("THEN ");
        this.out.beginBlock(BLOCK);
        this.writeQueryBody(TermFactory.queryAnd(rule.getHead()));
        this.out.endBlock();
    }

    private void writeQueryBody(QueryAtom body) {
        if (body != null) {
            this.negationCount = 1;
            this.referenceCounter = new ReferenceCounter(body);
            body.accept(this.atomWriter);
        }
    }

    private void writeAxiom(Term axiom) {
        this.writeAxioms(Collections.singleton(axiom));
    }

    private void writeAxioms(Iterable<? extends Term> axioms) {
        this.axiomWriter.write(axioms, new TurtleRDFOutput(this.out, this.turtle));
    }

    private boolean isSafe(Variable var, QueryAtom atom) {
        int allReferences = this.referenceCounter.countReferences(var);
        int atomReferences = new ReferenceCounter(atom).countReferences(var);
        return atomReferences == allReferences;
    }

    private void writeFunctionCall(FunctionEval atom) {
        if (atom.getFunction().equals(Functions.NOT)) {
            this.writeNegatedFunction(atom);
        } else if (INFIX_SYMBOLS.containsKey(atom.getFunction())) {
            this.writeInfixFunction(INFIX_SYMBOLS.get(atom.getFunction()), atom);
        } else {
            this.writeNaryFunction(atom);
        }
    }

    private void writeDatatypeFunction(DatatypeAtom atom) {
        Datatype datatype = atom.getDatatype();
        if (datatype.equals(Datatypes.LITERAL)) {
            this.out.append((CharSequence)"true");
        }
        this.out.append((CharSequence)"datatype(");
        this.writeFunctionArg(atom.getLiteral());
        this.out.append((CharSequence)") = ");
        this.writeEntity(datatype);
    }

    private void writeNegatedFunction(FunctionEval atom) {
        this.out.append((CharSequence)"!(");
        this.writeFunctionArg((Expression)atom.get(0));
        this.out.append((CharSequence)")");
    }

    private void writeInfixFunction(String connective, FunctionEval call) {
        boolean withNewLine = REQUIRES_NEWLINE.apply((Object)call);
        Iterator i = call.iterator();
        if (i.hasNext()) {
            boolean hasMore = withNewLine;
            if (hasMore) {
                this.out.append((CharSequence)"(");
            }
            this.out.beginBlock();
            Connector connector = new Connector(connective, withNewLine, false);
            while (i.hasNext()) {
                connector.print(this.out);
                Expression atom = (Expression)i.next();
                this.writeFunctionArg(atom);
            }
            this.out.endBlock();
            if (hasMore) {
                this.out.print(")");
            }
        }
    }

    private void writeNaryFunction(FunctionEval atom) {
        com.clarkparsia.pellet.api.term.function.Function f = atom.getFunction();
        Iterator args = atom.iterator();
        if (f.equals(Functions.IN)) {
            this.writeFunctionArg((Expression)args.next());
            this.out.append((CharSequence)" IN ");
        } else if (SPARQL_NAMES.containsKey(f)) {
            this.out.append((CharSequence)SPARQL_NAMES.get(f));
        } else if (f.getName().startsWith(Functions.NS.SPARQL.toString())) {
            this.out.append((CharSequence)URI.create(f.getName()).getFragment());
        } else {
            this.out.append((CharSequence)"<").append(f.getName()).append(">");
        }
        this.out.append((CharSequence)"(");
        Connector connector = new Connector(",");
        while (args.hasNext()) {
            connector.print(this.out);
            this.writeFunctionArg((Expression)args.next());
        }
        this.out.append((CharSequence)")");
    }

    private void writeFunctionArg(Expression arg) {
        if (arg instanceof FunctionEval) {
            this.writeFunctionCall((FunctionEval)arg);
        } else if (arg instanceof Entity) {
            this.writeEntity((Entity)arg);
        } else {
            throw new UnsupportedOperationException("Cannot serialize: " + String.valueOf(arg));
        }
    }

    private void writeEntity(Entity entity) {
        if (entity.isVariable()) {
            this.out.append((CharSequence)this.turtle.createVariable(((NamedTerm)((Object)entity)).getName()));
        } else if (entity.isNamed()) {
            this.out.append((CharSequence)this.turtle.createResource(((NamedTerm)((Object)entity)).getName()));
        } else if (entity instanceof Literal) {
            Literal literal = (Literal)entity;
            if (literal.hasLanguage()) {
                this.out.append((CharSequence)this.turtle.createPlainLiteral(literal.getLexicalValue(), literal.getLanguage()));
            } else if (literal.getDatatype().equals(Datatypes.STRING)) {
                this.out.append((CharSequence)this.turtle.createPlainLiteral(literal.getLexicalValue()));
            } else {
                this.out.append((CharSequence)this.turtle.createTypedLiteral(literal.getLexicalValue(), literal.getDatatype().getName()));
            }
        } else {
            this.out.append((CharSequence)entity.toString());
        }
    }

    private void writeValues(Iterable<? extends Entity> values) {
        Connector connector = new Connector(" ");
        for (Entity entity : values) {
            connector.print(this.out);
            this.writeEntity(entity);
        }
    }

    private void writeOrderConditions(Iterable<OrderCondition> values) {
        Connector connector = new Connector(" ");
        for (OrderCondition cond : values) {
            connector.print(this.out);
            if (!cond.isAscending()) {
                this.out.print("DESC(");
            }
            this.writeEntity(cond.getVariable());
            if (cond.isAscending()) continue;
            this.out.print(")");
        }
    }

    private static class ReferenceCounter
    extends RecursiveTermVisitorVoid {
        QueryAtom body;
        Variable var;
        int count;

        public ReferenceCounter(QueryAtom body) {
            this.body = body;
        }

        private int countReferences(Variable var) {
            this.var = var;
            this.count = 0;
            this.body.accept(this);
            return this.count;
        }

        @Override
        protected void defaultVisit(Term term) {
            if (term.equals(this.var)) {
                ++this.count;
            }
        }
    }

    private class Connector {
        private final String connective;
        private final boolean newLineBefore;
        private final boolean newLineAfter;
        private final boolean needsSpace;
        private boolean first = true;

        public Connector(String connective) {
            this(connective, false, false);
        }

        public Connector(String connective, boolean newLineBefore, boolean newLineAfter) {
            this.connective = connective;
            this.needsSpace = !connective.equals(" ");
            this.newLineBefore = newLineBefore;
            this.newLineAfter = newLineAfter;
        }

        public boolean print(BlockWriter out) {
            if (this.first) {
                this.first = false;
                return false;
            }
            this.printNewLineOrSpace(this.newLineBefore, this.needsSpace);
            out.print(this.connective);
            this.printNewLineOrSpace(this.newLineAfter, this.needsSpace);
            return true;
        }

        private void printNewLineOrSpace(boolean newLine, boolean space) {
            if (newLine) {
                SPARQLSerializer.this.out.println();
            } else if (space) {
                SPARQLSerializer.this.out.printSpace();
            }
        }
    }

    private static abstract class TypeSafePredicate<T, E>
    implements Predicate<T> {
        private final boolean defaultValue;
        private final Class<E> type;

        public TypeSafePredicate(Class<E> type, boolean defaultValue) {
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public final boolean apply(T element) {
            return this.type.isInstance(element) ? this.applyTypeSafe(this.type.cast(element)) : this.defaultValue;
        }

        public abstract boolean applyTypeSafe(E var1);
    }
}

