/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query;

import com.clarkparsia.pellet.api.query.Binding;
import com.clarkparsia.pellet.api.query.ResultSet;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class ResultSetPrinter {
    private static final String LINE_BREAK = System.getProperty("line.separator");

    public static void print(ResultSet results) {
        ResultSetPrinter.printTSV(results);
    }

    public static void printCSV(ResultSet results) {
        ResultSetPrinter.printCSV(System.out, results);
    }

    public static void printCSV(Appendable out, ResultSet results) {
        ResultSetPrinter.printSV(out, results, ',');
    }

    public static void printTSV(ResultSet results) {
        ResultSetPrinter.printTSV(System.out, results);
    }

    public static void printTSV(Appendable out, ResultSet results) {
        ResultSetPrinter.printSV(out, results, '\t');
    }

    public static void printSV(Appendable out, ResultSet results, char seperator) {
        try {
            Set<Variable> vars = results.getSelectVariables();
            ResultSetPrinter.print(out, vars, seperator);
            out.append(LINE_BREAK);
            for (Binding binding : results) {
                ResultSetPrinter.print(out, Iterables.transform(vars, (Function)binding), seperator);
                out.append(LINE_BREAK);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void print(Appendable out, Iterable<?> elements, char seperator) throws IOException {
        Iterator<?> i = elements.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (element != null) {
                out.append(element.toString());
            }
            if (!i.hasNext()) continue;
            out.append(seperator);
        }
    }
}

