/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query;

import com.clarkparsia.pellet.api.query.Query;
import com.clarkparsia.pellet.api.query.impl.OrderConditionImpl;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.query.QueryAtom;
import java.util.Collection;

public class QueryBuilder<Q extends Query<?>> {
    protected final Q query;

    protected QueryBuilder(Q query) {
        this.query = query;
    }

    public QueryBuilder<Q> where(QueryAtom atom) {
        this.query.setBody(atom);
        return this;
    }

    public QueryBuilder<Q> where(QueryAtom ... atoms) {
        return this.where((QueryAtom)TermFactory.queryAnd(atoms));
    }

    public QueryBuilder<Q> where(Collection<QueryAtom> atoms) {
        return this.where(TermFactory.queryAnd(atoms));
    }

    public QueryBuilder<Q> limit(long limit) {
        this.query.setLimit(limit);
        return this;
    }

    public QueryBuilder<Q> offset(long offset) {
        this.query.setOffset(offset);
        return this;
    }

    public QueryBuilder<Q> orderBy(Variable var) {
        this.query.addOrderBy(new OrderConditionImpl(var));
        return this;
    }

    public QueryBuilder<Q> orderByDesc(Variable var) {
        this.query.addOrderBy(new OrderConditionImpl(var, false));
        return this;
    }

    public Q build() {
        return this.query;
    }
}

