/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.kb;

import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.kb.MemOntology;
import com.clarkparsia.pellet.api.kb.Ontology;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;

public class OntologyFactory {
    public static Ontology createOntology() {
        return OntologyFactory.createOntology((String)null);
    }

    public static Ontology createOntology(String name) {
        return new MemOntology(name);
    }

    public static Ontology createOntology(Axiom ... axioms) {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.add(Arrays.asList(axioms));
        return ontology;
    }

    public static Ontology createOntology(String name, Axiom ... axioms) {
        Ontology ontology = OntologyFactory.createOntology(name);
        ontology.add(Arrays.asList(axioms));
        return ontology;
    }

    public static Ontology createOntology(Iterable<Axiom> axioms) {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.add(axioms);
        return ontology;
    }

    public static Ontology createOntology(String name, Iterable<Axiom> axioms) {
        Ontology ontology = OntologyFactory.createOntology(name);
        ontology.add(axioms);
        return ontology;
    }

    public static Ontology readOntology(String url) throws IOException {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.read(url);
        return ontology;
    }

    public static Ontology readOntology(InputStream in) throws IOException {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.read(in);
        return ontology;
    }

    public static Ontology readOntology(Reader reader) throws IOException {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.read(reader);
        return ontology;
    }

    public static Ontology readOntology(String url, OntologySyntax syntax) throws IOException {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.read(url, syntax);
        return ontology;
    }

    public static Ontology readOntology(InputStream in, OntologySyntax syntax) throws IOException {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.read(in, syntax);
        return ontology;
    }

    public static Ontology readOntology(Reader reader, OntologySyntax syntax) throws IOException {
        Ontology ontology = OntologyFactory.createOntology();
        ontology.read(reader, syntax);
        return ontology;
    }
}

