/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.kb;

import com.clarkparsia.pellet.api.kb.Expressivity;
import com.clarkparsia.pellet.api.term.axiom.DataFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.DatatypeDefinition;
import com.clarkparsia.pellet.api.term.axiom.DisjointDataProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointUnion;
import com.clarkparsia.pellet.api.term.axiom.InverseProperties;
import com.clarkparsia.pellet.api.term.axiom.ObjectFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.SubDataPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyChain;
import com.clarkparsia.pellet.api.term.axiom.Symmetric;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataHasValue;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.InverseObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectSelf;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.visitor.RecursiveTermVisitorVoid;

public class ExpressivityVisitor
extends RecursiveTermVisitorVoid {
    private Expressivity expressivity;

    public ExpressivityVisitor(Expressivity expressivity) {
        this.expressivity = expressivity;
    }

    @Override
    public void visit(RestrictedDatatype datatype) {
        this.expressivity.setHasDatatype(true);
        this.expressivity.setHasUserDefinedDatatype(true);
    }

    @Override
    public void visit(DataAll all) {
        super.visit(all);
        this.expressivity.setHasDatatype(true);
        this.expressivity.setHasAllValues(true);
    }

    @Override
    public void visit(DataCardinality card) {
        super.visit(card);
        this.expressivity.setHasDatatype(true);
        this.expressivity.setHasCardinalityD(true);
    }

    @Override
    public void visit(DataFunctional axiom) {
        super.visit(axiom);
        this.expressivity.setHasDatatype(true);
        this.expressivity.setHasFunctionalityD(true);
    }

    @Override
    public void visit(DataHasValue value) {
        this.expressivity.setHasUserDefinedDatatype(true);
    }

    @Override
    public void visit(DataInverseFunctional axiom) {
        this.expressivity.setHasKeys(true);
    }

    @Override
    public void visit(DataMax max) {
        super.visit(max);
        this.expressivity.setHasDatatype(true);
        this.expressivity.setHasCardinalityD(true);
    }

    @Override
    public void visit(DataMin min) {
        super.visit(min);
        this.expressivity.setHasDatatype(true);
        this.expressivity.setHasCardinalityD(true);
    }

    @Override
    public void visit(DataSome some) {
        super.visit(some);
        this.expressivity.setHasDatatype(true);
    }

    @Override
    public void visit(DatatypeDefinition datatype) {
        super.visit(datatype);
        this.expressivity.setHasDatatype(true);
    }

    @Override
    public void visit(DataAnd and) {
        this.expressivity.setHasUserDefinedDatatype(true);
    }

    @Override
    public void visit(DataNot not) {
        this.expressivity.setHasUserDefinedDatatype(true);
    }

    @Override
    public void visit(DataOr or) {
        this.expressivity.setHasUserDefinedDatatype(true);
    }

    @Override
    public void visit(DataOneOf oneOf) {
        this.expressivity.setHasUserDefinedDatatype(true);
    }

    @Override
    public void visit(DataPropertyDomain domain) {
        this.expressivity.setHasDatatype(true);
    }

    @Override
    public void visit(DataPropertyRange range) {
        this.expressivity.setHasDatatype(true);
    }

    @Override
    public void visit(DisjointDataProperties axiom) {
        this.expressivity.setHasDisjointRoles(true);
    }

    @Override
    public void visit(DisjointObjectProperties axiom) {
        this.expressivity.setHasDisjointRoles(true);
        for (ObjectProperty prop : axiom) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(SubDataPropertyOf sub) {
        this.expressivity.setHasDatatype(true);
    }

    @Override
    public void visit(SubObjectPropertyChain axiom) {
        this.expressivity.setHasComplexSubRoles(true);
        axiom.getSub().accept(this);
        axiom.getSuper().accept(this);
    }

    @Override
    public void visit(ObjectAll all) {
        super.visit(all);
        this.expressivity.setHasAllValues(true);
    }

    @Override
    public void visit(ObjectCardinality card) {
        super.visit(card);
        if (card.getQualification().equals(Classes.THING)) {
            this.expressivity.setHasCardinality(true);
        } else {
            this.expressivity.setHasCardinalityQ(true);
        }
    }

    @Override
    public void visit(ObjectFunctional axiom) {
        super.visit(axiom);
        this.expressivity.setHasFunctionality(true);
    }

    @Override
    public void visit(ObjectHasValue value) {
        value.getProperty().accept(this);
        this.expressivity.addNominal(value.getValue());
    }

    @Override
    public void visit(ObjectInverseFunctional axiom) {
        super.visit(axiom);
        this.expressivity.setHasFunctionality(true);
    }

    @Override
    public void visit(ObjectMax max) {
        super.visit(max);
        if (max.isQualified()) {
            this.expressivity.setHasCardinalityQ(true);
        } else {
            this.expressivity.setHasCardinality(true);
        }
    }

    @Override
    public void visit(ObjectMin min) {
        super.visit(min);
        if (min.isQualified()) {
            this.expressivity.setHasCardinalityQ(true);
        } else {
            this.expressivity.setHasCardinality(true);
        }
    }

    @Override
    public void visit(ObjectNot not) {
        super.visit(not);
        this.expressivity.setHasNegation(true);
    }

    @Override
    public void visit(ObjectOr or) {
        super.visit(or);
        this.expressivity.setHasUnion(true);
    }

    @Override
    public void visit(ObjectSelf self) {
        super.visit(self);
        this.expressivity.setHasSelf(true);
    }

    @Override
    public void visit(ObjectOneOf oneOf) {
        for (Individual nominal : oneOf) {
            this.expressivity.addNominal(nominal);
        }
    }

    @Override
    public void visit(ObjectPropertyRange range) {
        super.visit(range);
        this.expressivity.setHasRange(true);
    }

    @Override
    public void visit(InverseObjectProperty p) {
        this.expressivity.setHasInverse(true);
        this.expressivity.addAnonInverse(p.getNamedProperty());
    }

    @Override
    public void visit(InverseProperties axiom) {
        this.expressivity.setHasInverse(true);
    }

    @Override
    public void visit(Symmetric axiom) {
        this.expressivity.setHasInverse(true);
    }

    @Override
    public void visit(DisjointUnion union) {
        this.expressivity.setHasUnion(true);
    }
}

