/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.io.impl;

import com.clarkparsia.pellet.api.io.ANSICode;
import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.clarkparsia.pellet.api.io.impl.AbstractOntologyWriter;
import com.clarkparsia.pellet.api.query.SPARQLSerializer;
import com.clarkparsia.pellet.api.term.NamedTerm;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.axiom.AnnotationPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.AnnotationPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Asymmetric;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.axiom.AxiomAnnotation;
import com.clarkparsia.pellet.api.term.axiom.DataFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.DatatypeDefinition;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.DifferentIndividuals;
import com.clarkparsia.pellet.api.term.axiom.DisjointClasses;
import com.clarkparsia.pellet.api.term.axiom.DisjointDataProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointUnion;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.axiom.EquivalentClasses;
import com.clarkparsia.pellet.api.term.axiom.EquivalentDataProperties;
import com.clarkparsia.pellet.api.term.axiom.EquivalentObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.HasKey;
import com.clarkparsia.pellet.api.term.axiom.InverseProperties;
import com.clarkparsia.pellet.api.term.axiom.Irreflexive;
import com.clarkparsia.pellet.api.term.axiom.NamedAnnotationEntity;
import com.clarkparsia.pellet.api.term.axiom.NegativeDataPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.NegativeObjectPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.ObjectFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Reflexive;
import com.clarkparsia.pellet.api.term.axiom.SameIndividual;
import com.clarkparsia.pellet.api.term.axiom.SubAnnotationPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubClassOf;
import com.clarkparsia.pellet.api.term.axiom.SubDataPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyChain;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.Symmetric;
import com.clarkparsia.pellet.api.term.axiom.Transitive;
import com.clarkparsia.pellet.api.term.axiom.TypeAssertion;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Facets;
import com.clarkparsia.pellet.api.term.entity.AnnotationPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.AnonIndividual;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataHasValue;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.DataPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.DatatypeVariable;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.FacetRestriction;
import com.clarkparsia.pellet.api.term.entity.IndividualVariable;
import com.clarkparsia.pellet.api.term.entity.InverseObjectProperty;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.LiteralVariable;
import com.clarkparsia.pellet.api.term.entity.NamedAnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.NamedIndividual;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyList;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.ObjectSelf;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.entity.QualifiedCardinalityRestriction;
import com.clarkparsia.pellet.api.term.entity.QualifiedRestriction;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.query.DirectSubClassOf;
import com.clarkparsia.pellet.api.term.query.DirectSubDataPropertyOf;
import com.clarkparsia.pellet.api.term.query.DirectSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.query.DirectTypeAssertion;
import com.clarkparsia.pellet.api.term.query.StrictSubClassOf;
import com.clarkparsia.pellet.api.term.query.StrictSubDataPropertyOf;
import com.clarkparsia.pellet.api.term.query.StrictSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.rule.Rule;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitorVoid;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.clarkparsia.pellet.rdf.RDFTerm;
import com.complexible.common.base.Options;
import com.complexible.common.util.PrefixMapping;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class TerpWriter
extends AbstractOntologyWriter {
    private static Map<TermType, ANSICode> COLORS = ImmutableMap.of((Object)((Object)TermType.AXIOM), (Object)((Object)ANSICode.GREEN), (Object)((Object)TermType.RESTR), (Object)((Object)ANSICode.PURPLE), (Object)((Object)TermType.LOGICAL), (Object)((Object)ANSICode.CYAN), (Object)((Object)TermType.BUILTIN), (Object)((Object)ANSICode.BLUE), (Object)((Object)TermType.LITERAL), (Object)((Object)ANSICode.YELLOW));
    private PrefixMapping prefixes;
    private boolean autoGeneratePrefixes;
    private boolean writePrefixes;
    private PrintWriter out;
    private SPARQLSerializer ss;
    private boolean enableColors;
    private ANSICode currentColor;
    TermVisitorVoid axiomWriter = new BaseTermVisitorVoid(){

        @Override
        public void visit(DisjointClasses axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL_disjointWith, axiom);
        }

        @Override
        public void visit(DisjointUnion axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getNamedClass(), RDFTerm.OWL2_disjointUnionOf, axiom.getDefinition());
        }

        @Override
        public void visit(EquivalentClasses axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL_equivalentClass, axiom);
        }

        @Override
        public void visit(SubClassOf axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSub(), RDFTerm.RDFS_subClassOf, (Term)axiom.getSuper());
        }

        @Override
        public void visit(DataPropertyAssertion axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSubject(), axiom.getProperty(), (Term)axiom.getObject());
        }

        @Override
        public void visit(DifferentIndividuals axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL_differentFrom, axiom);
        }

        @Override
        public void visit(TypeAssertion axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getIndividual(), RDFTerm.RDF_type, (Term)axiom.getType());
        }

        @Override
        public void visit(NegativeDataPropertyAssertion axiom) {
            TerpWriter.this.writelnNegatedTriple(axiom.getSubject(), axiom.getProperty(), axiom.getObject());
        }

        @Override
        public void visit(NegativeObjectPropertyAssertion axiom) {
            TerpWriter.this.writelnNegatedTriple(axiom.getSubject(), axiom.getProperty(), axiom.getObject());
        }

        @Override
        public void visit(ObjectPropertyAssertion axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSubject(), axiom.getProperty(), (Term)axiom.getObject());
        }

        @Override
        public void visit(SameIndividual axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL_sameAs, axiom);
        }

        @Override
        public void visit(Asymmetric axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL2_AsymmetricProperty, axiom.getProperty());
        }

        @Override
        public void visit(DataPropertyDomain axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.RDFS_domain, (Term)axiom.getDomain());
        }

        @Override
        public void visit(DataPropertyRange axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.RDFS_range, (Term)axiom.getRange());
        }

        @Override
        public void visit(DisjointDataProperties axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL2_propertyDisjointWith, axiom);
        }

        @Override
        public void visit(DisjointObjectProperties axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL2_propertyDisjointWith, axiom);
        }

        @Override
        public void visit(EquivalentDataProperties axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL_equivalentProperty, axiom);
        }

        @Override
        public void visit(EquivalentObjectProperties axiom) {
            TerpWriter.this.writeBinaryForEach(RDFTerm.OWL_equivalentProperty, axiom);
        }

        @Override
        public void visit(DataFunctional axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL_FunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(ObjectFunctional axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL_FunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(DataInverseFunctional axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL_InverseFunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(ObjectInverseFunctional axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL_InverseFunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(InverseProperties axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.OWL_inverseOf, (Term)axiom.getInverseProperty());
        }

        @Override
        public void visit(Irreflexive axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL2_IrreflexiveProperty, axiom.getProperty());
        }

        @Override
        public void visit(ObjectPropertyRange axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.RDFS_range, (Term)axiom.getRange());
        }

        @Override
        public void visit(ObjectPropertyDomain axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.RDFS_domain, (Term)axiom.getDomain());
        }

        @Override
        public void visit(Reflexive axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL2_ReflexiveProperty, axiom.getProperty());
        }

        @Override
        public void visit(SubDataPropertyOf axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSub(), RDFTerm.RDFS_subPropertyOf, (Term)axiom.getSuper());
        }

        @Override
        public void visit(SubObjectPropertyChain axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSuper(), RDFTerm.OWL2_propertyChainAxiom, axiom.getSub().getArgs());
        }

        @Override
        public void visit(SubObjectPropertyOf axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSub(), RDFTerm.RDFS_subPropertyOf, (Term)axiom.getSuper());
        }

        @Override
        public void visit(Symmetric axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL_SymmetricProperty, axiom.getProperty());
        }

        @Override
        public void visit(Transitive axiom) {
            TerpWriter.this.writeUnary(RDFTerm.OWL_TransitiveProperty, axiom.getProperty());
        }

        @Override
        public void visit(DatatypeDefinition axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getDatatype(), RDFTerm.OWL_equivalentClass, (Term)axiom.getDefinition());
        }

        @Override
        public void visit(Rule axiom) {
            TerpWriter.this.ss.serialize(axiom, (Writer)TerpWriter.this.out);
        }

        @Override
        public void visit(Declaration declaration) {
            NamedEntity entity = declaration.getEntity();
            if (TerpWriter.this.options.get(OntologyWriterOptions.DECLARATION_HANDLING) != OntologyWriterOptions.DeclarationHandling.WRITE_NONE) {
                TerpWriter.this.writelnTriple((Term)entity, RDFTerm.RDF_type, entity.accept(TerpWriter.this.declarationFinder));
            }
        }

        @Override
        public void visit(AxiomAnnotation annotation) {
        }

        @Override
        public void visit(EntityAnnotation annotation) {
            TerpWriter.this.writelnTriple((Term)annotation.getSubject(), annotation.getProperty(), (Term)annotation.getObject());
        }

        @Override
        public void visit(AnnotationPropertyDomain axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.RDFS_domain, (Term)axiom.getDomain());
        }

        @Override
        public void visit(AnnotationPropertyRange axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getProperty(), RDFTerm.RDFS_range, (Term)axiom.getRange());
        }

        @Override
        public void visit(SubAnnotationPropertyOf axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getSub(), RDFTerm.RDFS_subPropertyOf, (Term)axiom.getSuper());
        }

        @Override
        public void visit(HasKey axiom) {
            TerpWriter.this.writelnTriple((Term)axiom.getKeyClass(), RDFTerm.OWL2_hasKey, axiom.getProperties());
        }

        @Override
        public void visit(DirectSubClassOf query) {
            TerpWriter.this.writelnTriple((Term)query.getSub(), RDFTerm.SPARQL_directSubClassOf, (Term)query.getSuper());
        }

        @Override
        public void visit(StrictSubClassOf query) {
            TerpWriter.this.writelnTriple((Term)query.getSub(), RDFTerm.SPARQL_strictSubClassOf, (Term)query.getSuper());
        }

        @Override
        public void visit(DirectSubObjectPropertyOf query) {
            TerpWriter.this.writelnTriple((Term)query.getSub(), RDFTerm.SPARQL_directSubPropertyOf, (Term)query.getSuper());
        }

        @Override
        public void visit(StrictSubObjectPropertyOf query) {
            TerpWriter.this.writelnTriple((Term)query.getSub(), RDFTerm.SPARQL_strictSubPropertyOf, (Term)query.getSuper());
        }

        @Override
        public void visit(DirectSubDataPropertyOf query) {
            TerpWriter.this.writelnTriple((Term)query.getSub(), RDFTerm.SPARQL_directSubPropertyOf, (Term)query.getSuper());
        }

        @Override
        public void visit(StrictSubDataPropertyOf query) {
            TerpWriter.this.writelnTriple((Term)query.getSub(), RDFTerm.SPARQL_strictSubPropertyOf, (Term)query.getSuper());
        }

        @Override
        public void visit(DirectTypeAssertion query) {
            TerpWriter.this.writelnTriple((Term)query.getIndividual(), RDFTerm.SPARQL_directType, (Term)query.getType());
        }
    };
    TermVisitor<RDFTerm> declarationFinder = new BaseTermVisitor<RDFTerm>(){

        @Override
        public RDFTerm visit(AnonIndividual ind) {
            return TerpWriter.this.getIndividualDeclarationTerm();
        }

        @Override
        public RDFTerm visit(NamedAnnotationProperty p) {
            return RDFTerm.OWL_AnnotationProperty;
        }

        @Override
        public RDFTerm visit(NamedClass c) {
            return RDFTerm.OWL_Class;
        }

        @Override
        public RDFTerm visit(NamedDataProperty p) {
            return RDFTerm.OWL_DatatypeProperty;
        }

        @Override
        public RDFTerm visit(NamedDatatype d) {
            return RDFTerm.RDFS_Datatype;
        }

        @Override
        public RDFTerm visit(NamedIndividual ind) {
            return TerpWriter.this.getIndividualDeclarationTerm();
        }

        @Override
        public RDFTerm visit(NamedObjectProperty p) {
            return RDFTerm.OWL_ObjectProperty;
        }

        @Override
        public RDFTerm visit(AnnotationPropertyVariable p) {
            return RDFTerm.OWL_AnnotationProperty;
        }

        @Override
        public RDFTerm visit(IndividualVariable var) {
            return TerpWriter.this.getIndividualDeclarationTerm();
        }

        @Override
        public RDFTerm visit(ObjectPropertyVariable var) {
            return RDFTerm.OWL_ObjectProperty;
        }

        @Override
        public RDFTerm visit(DataPropertyVariable var) {
            return RDFTerm.OWL_DatatypeProperty;
        }

        @Override
        public RDFTerm visit(DatatypeVariable var) {
            return RDFTerm.RDFS_Datatype;
        }

        @Override
        public RDFTerm visit(ClassVariable var) {
            return RDFTerm.OWL_Class;
        }
    };
    TermVisitorVoid entityWriter = new BaseTermVisitorVoid(){

        @Override
        protected void defaultVisit(Term term) {
            throw new IllegalArgumentException(term.toString());
        }

        @Override
        public void visit(LiteralVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(IndividualVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(AnnotationPropertyVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(ObjectPropertyVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(DataPropertyVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(DatatypeVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(ClassVariable var) {
            TerpWriter.this.writeVar(var);
        }

        @Override
        public void visit(NamedAnnotationEntity entity) {
            TerpWriter.this.writeURI(entity.getName());
        }

        @Override
        public void visit(AnonIndividual ind) {
            TerpWriter.this.out.print(ind.getName());
        }

        @Override
        public void visit(NamedIndividual ind) {
            TerpWriter.this.writeURI(ind);
        }

        @Override
        public void visit(NamedClass cls) {
            TerpWriter.this.writeURI(cls);
        }

        @Override
        public void visit(NamedAnnotationProperty p) {
            TerpWriter.this.writeURI(p);
        }

        @Override
        public void visit(NamedDataProperty p) {
            TerpWriter.this.writeURI(p);
        }

        @Override
        public void visit(NamedObjectProperty p) {
            TerpWriter.this.writeURI(p);
        }

        @Override
        public void visit(ObjectPropertyList p) {
            TerpWriter.this.writeList(p);
        }

        @Override
        public void visit(NamedDatatype d) {
            TerpWriter.this.writeURI(d);
        }

        @Override
        public void visit(ObjectAll term) {
            this.visitRestriction(term, "only");
        }

        @Override
        public void visit(DataAll term) {
            this.visitRestriction(term, "only");
        }

        @Override
        public void visit(ObjectSome term) {
            this.visitRestriction(term, "some");
        }

        @Override
        public void visit(DataSome term) {
            this.visitRestriction(term, "some");
        }

        @Override
        public void visit(ObjectMin term) {
            this.visitRestriction(term, "min");
        }

        @Override
        public void visit(DataMin term) {
            this.visitRestriction(term, "min");
        }

        @Override
        public void visit(ObjectMax term) {
            this.visitRestriction(term, "max");
        }

        @Override
        public void visit(DataMax term) {
            this.visitRestriction(term, "max");
        }

        @Override
        public void visit(ObjectCardinality term) {
            this.visitRestriction(term, "exactly");
        }

        @Override
        public void visit(DataCardinality term) {
            this.visitRestriction(term, "exactly");
        }

        public void visitRestriction(QualifiedRestriction term, String name) {
            TerpWriter.this.out.print("(");
            term.getProperty().accept(this);
            TerpWriter.this.out.print(' ');
            TerpWriter.this.writeStr(name, TermType.RESTR);
            TerpWriter.this.out.print(' ');
            term.getQualification().accept(this);
            TerpWriter.this.out.print(")");
        }

        public void visitRestriction(QualifiedCardinalityRestriction term, String name) {
            TerpWriter.this.out.print("(");
            term.getProperty().accept(this);
            TerpWriter.this.out.print(' ');
            TerpWriter.this.writeStr(name, TermType.RESTR);
            TerpWriter.this.out.print(' ');
            TerpWriter.this.out.print(term.getCardinality());
            TerpWriter.this.out.append(' ');
            term.getQualification().accept(this);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(ObjectAnd term) {
            TerpWriter.this.out.print("(");
            TerpWriter.this.writeList(term, "and", TermType.LOGICAL);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(DataAnd term) {
            TerpWriter.this.out.print("(");
            TerpWriter.this.writeList(term, "and", TermType.LOGICAL);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(ObjectHasValue term) {
            TerpWriter.this.out.print("(");
            term.getProperty().accept(this);
            TerpWriter.this.writeStr(" value ", TermType.RESTR);
            term.getValue().accept(this);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(DataHasValue term) {
            TerpWriter.this.out.print("(");
            term.getProperty().accept(this);
            TerpWriter.this.writeStr(" value ", TermType.RESTR);
            term.getValue().accept(this);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(InverseObjectProperty p) {
            TerpWriter.this.writeStr("inverse ", TermType.BUILTIN);
            p.getProperty().accept(this);
        }

        @Override
        public void visit(Literal term) {
            String lexicalValue = term.getLexicalValue();
            NamedDatatype datatype = term.getDatatype();
            TerpWriter.this.beginColor(TermType.LITERAL);
            if (datatype.equals(Datatypes.INTEGER) || datatype.equals(Datatypes.DECIMAL)) {
                TerpWriter.this.out.print(lexicalValue);
            } else if (datatype.equals(Datatypes.FLOAT)) {
                TerpWriter.this.out.print(lexicalValue);
                TerpWriter.this.out.print("f");
            } else {
                TerpWriter.this.out.print("\"" + lexicalValue + "\"");
                if (term.hasLanguage()) {
                    TerpWriter.this.out.print("@" + term.getLanguage());
                } else if (!datatype.equals(Datatypes.STRING)) {
                    TerpWriter.this.out.print("^^");
                    datatype.accept(this);
                }
            }
            TerpWriter.this.endColor();
        }

        @Override
        public void visit(ObjectNot term) {
            TerpWriter.this.writeStr("not ", TermType.LOGICAL);
            term.getArg().accept(this);
        }

        @Override
        public void visit(DataNot term) {
            TerpWriter.this.writeStr("not ", TermType.LOGICAL);
            term.getArg().accept(this);
        }

        @Override
        public void visit(ObjectOneOf term) {
            TerpWriter.this.out.print("{");
            TerpWriter.this.writeList(term, " ");
            TerpWriter.this.out.print("}");
        }

        @Override
        public void visit(DataOneOf term) {
            TerpWriter.this.out.print("{");
            TerpWriter.this.writeList(term, " ");
            TerpWriter.this.out.print("}");
        }

        @Override
        public void visit(ObjectOr term) {
            TerpWriter.this.out.print("(");
            TerpWriter.this.writeList(term, "or", TermType.LOGICAL);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(DataOr term) {
            TerpWriter.this.out.print("(");
            TerpWriter.this.writeList(term, "or", TermType.LOGICAL);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(ObjectSelf term) {
            TerpWriter.this.out.print("(");
            term.getProperty().accept(this);
            TerpWriter.this.writeStr(" Self", TermType.RESTR);
            TerpWriter.this.out.print(")");
        }

        @Override
        public void visit(FacetRestriction restr) {
            Facet facet = restr.getFacet();
            LiteralValue lit = restr.getValue();
            if (facet instanceof Facets) {
                TerpWriter.this.out.append(((Facets)facet).getSymbol());
                lit.accept(this);
            } else {
                TerpWriter.this.out.append(facet.getName());
                TerpWriter.this.out.append('(');
                lit.accept(this);
                TerpWriter.this.out.append(')');
            }
        }

        @Override
        public void visit(RestrictedDatatype dt) {
            TerpWriter.this.out.print("");
            dt.getDatatype().accept(this);
            TerpWriter.this.out.print("[");
            Iterator i = dt.getRestrictions().iterator();
            while (i.hasNext()) {
                FacetRestriction facetRestr = (FacetRestriction)i.next();
                Facet facet = facetRestr.getFacet();
                if (facet instanceof Facets) {
                    TerpWriter.this.out.print(((Facets)facet).getSymbol());
                } else {
                    TerpWriter.this.writeURI(facet);
                }
                TerpWriter.this.out.print(" ");
                facetRestr.getValue().accept(this);
                if (!i.hasNext()) continue;
                TerpWriter.this.out.print(", ");
            }
            TerpWriter.this.out.print("]");
        }
    };

    private void writeUnary(RDFTerm type, Term subj) {
        this.writelnTriple(subj, RDFTerm.RDF_type, type);
    }

    private void writelnTriple(Term subj, RDFTerm pred, RDFTerm obj) {
        subj.accept(this.entityWriter);
        this.out.append(' ');
        this.writeURI(pred, TermType.AXIOM);
        this.out.append(' ');
        this.writeURI(obj, TermType.BUILTIN);
        this.out.println();
    }

    private void writelnTriple(Term subj, RDFTerm pred, Iterable<? extends Term> obj) {
        subj.accept(this.entityWriter);
        this.out.append(' ');
        this.writeURI(pred, TermType.AXIOM);
        this.out.append(' ');
        this.writeList(obj);
        this.out.println();
    }

    private void writelnTriple(Term subj, RDFTerm pred, Term obj) {
        subj.accept(this.entityWriter);
        this.out.append(' ');
        this.writeURI(pred, TermType.AXIOM);
        this.out.append(' ');
        obj.accept(this.entityWriter);
        this.out.println();
    }

    private void writelnTriple(Term subj, Term pred, Term obj) {
        this.writelnTriple(subj, pred, obj, false);
    }

    private void writelnNegatedTriple(Term subj, Term pred, Term obj) {
        this.writelnTriple(subj, pred, obj, true);
    }

    private void writelnTriple(Term subj, Term pred, Term obj, boolean negated) {
        subj.accept(this.entityWriter);
        this.out.append(' ');
        pred.accept(this.entityWriter);
        this.out.append(' ');
        obj.accept(this.entityWriter);
        this.out.println();
    }

    private void writeBinaryForEach(RDFTerm pred, Iterable<? extends Term> terms) {
        Iterator<? extends Term> it = terms.iterator();
        if (it.hasNext()) {
            Term subj = it.next();
            while (it.hasNext()) {
                this.writelnTriple(subj, pred, it.next());
            }
        }
    }

    private void writeList(Iterable<? extends Term> terms) {
        this.out.print("(");
        this.writeList(terms, " ");
        this.out.print(")");
    }

    private void writeList(Iterable<? extends Term> list, String op) {
        this.writeList(list, op, TermType.OTHER);
    }

    private void writeList(Iterable<? extends Term> list, String op, TermType color) {
        boolean noSeparator = op.equals(" ");
        Iterator<? extends Term> i = list.iterator();
        while (i.hasNext()) {
            Term term = i.next();
            term.accept(this.entityWriter);
            if (!i.hasNext()) continue;
            if (noSeparator) {
                this.out.print(op);
                continue;
            }
            this.writeStr(" " + op + " ", color);
        }
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    private boolean isQueryMode() {
        return this.options.is(OntologyWriterOptions.QUERY_MODE);
    }

    private void writeVar(Variable var) {
        this.out.print(var);
    }

    private RDFTerm getIndividualDeclarationTerm() {
        if (this.isQueryMode()) {
            return null;
        }
        switch ((OntologyWriterOptions.DeclarationHandling)((Object)this.options.get(OntologyWriterOptions.DECLARATION_HANDLING))) {
            case WRITE_ALL: 
            case WRITE_ASSERTED: {
                return RDFTerm.OWL2_NamedIndividual;
            }
            case WRITE_ALL_OWL_THING: {
                return RDFTerm.OWL_Thing;
            }
        }
        return null;
    }

    private void writeURI(NamedTerm term) {
        this.writeURI(term.getName());
    }

    private void writeURI(RDFTerm term, TermType type) {
        this.beginColor(type);
        if (term == RDFTerm.RDF_type) {
            this.out.print("a");
        } else {
            this.writeURI(term.getURI());
        }
        this.endColor();
    }

    private void writeURI(String uri) {
        String qname = this.prefixes.qname(uri, this.autoGeneratePrefixes);
        if (qname.equals(uri)) {
            this.out.append('<').append(uri).append('>');
        } else {
            this.out.print(qname);
        }
    }

    private void writeStr(String name, TermType type) {
        this.beginColor(type);
        this.out.print(name);
        this.endColor();
    }

    private void beginColor(TermType type) {
        if (this.enableColors) {
            this.currentColor = COLORS.get((Object)type);
            if (this.currentColor != null) {
                this.out.print((Object)this.currentColor);
            }
        }
    }

    private void endColor() {
        if (this.currentColor != null) {
            this.out.print((Object)ANSICode.RESET);
        }
    }

    public TerpWriter(Options options) {
        super(options, OntologySyntax.TERP);
        this.prefixes = (PrefixMapping)options.get(OntologyWriterOptions.PREFIX_MAPPING);
    }

    @Override
    public void write(Iterable<? extends Axiom> axioms, Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.prefixes = (PrefixMapping)this.options.get(OntologyWriterOptions.PREFIX_MAPPING);
        this.writePrefixes = (Boolean)this.options.get(OntologyWriterOptions.WRITE_PREFIXES);
        this.autoGeneratePrefixes = !this.writePrefixes && (Boolean)this.options.get(OntologyWriterOptions.AUTO_GENERATE_PREFIXES) != false;
        this.ss = new SPARQLSerializer(Options.of(OntologyWriterOptions.PREFIX_MAPPING, (Object)this.prefixes));
        this.enableColors = this.options.is(OntologyWriterOptions.ANSI_COLOR);
        this.currentColor = null;
        if (this.writePrefixes) {
            this.writePrefixes();
        }
        for (Axiom axiom : axioms) {
            axiom.accept(this.axiomWriter);
        }
        this.out.flush();
    }

    private void writePrefixes() {
        for (String prefix : this.prefixes.getPrefixes()) {
            this.out.print("PREFIX ");
            this.out.print(prefix);
            this.out.print(": <");
            this.out.print(this.prefixes.getNamespace(prefix));
            this.out.println(">");
        }
        if (!this.prefixes.getPrefixes().isEmpty()) {
            this.out.println();
        }
    }

    public static enum TermType {
        AXIOM,
        RESTR,
        LOGICAL,
        BUILTIN,
        LITERAL,
        OTHER;

    }
}

