/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.io.impl;

import com.clarkparsia.pellet.api.io.OntologyReader;
import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.kb.AxiomStore;
import com.complexible.common.base.Options;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public abstract class AbstractOntologyReader
implements OntologyReader {
    protected final Options options;
    protected final OntologySyntax syntax;

    public AbstractOntologyReader(Options options, OntologySyntax syntax) {
        this.options = options;
        this.syntax = syntax;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public OntologySyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public void read(AxiomStore store, String url) throws IOException {
        try {
            URLConnection conn = new URL(url).openConnection();
            conn.setRequestProperty("accept", "application/rdf+xml, application/xml; q=0.8, text/xml; q=0.7, application/rss+xml; q=0.3, */*; q=0.2");
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(store, conn.getInputStream());
            } else {
                this.read(store, new InputStreamReader(conn.getInputStream(), encoding));
            }
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }
}

