/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.io;

import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.io.OntologyWriter;
import com.clarkparsia.pellet.api.io.OntologyWriterFactory;
import com.clarkparsia.pellet.api.io.impl.TerpWriterFactory;
import com.complexible.common.base.Options;
import com.google.common.collect.Maps;
import java.util.Map;

public class OntologyWriters {
    private static final Map<OntologySyntax, OntologyWriterFactory> FACTORIES = Maps.newHashMap();

    private OntologyWriters() {
    }

    public static OntologyWriter create(OntologySyntax syntax) {
        OntologyWriterFactory factory = FACTORIES.get(syntax);
        if (factory == null) {
            throw new IllegalArgumentException("No writer registered for syntax: " + String.valueOf(syntax));
        }
        return (OntologyWriter)factory.create();
    }

    public static OntologyWriter create(OntologySyntax syntax, Options options) {
        return (OntologyWriter)FACTORIES.get(syntax).create(options);
    }

    public static void register(OntologyWriterFactory factory) {
        FACTORIES.put(factory.getSyntax(), factory);
    }

    public static void unregister(OntologyWriterFactory factory) {
        FACTORIES.remove(factory.getSyntax());
    }

    public static OntologyWriterFactory getFactory(OntologySyntax syntax) {
        return FACTORIES.get(syntax);
    }

    static {
        OntologyWriters.register(new TerpWriterFactory());
    }
}

