/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class XMLWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Writer _writer;
    private String _charEncoding;
    private boolean _prettyPrint = false;
    protected int _indentLevel = 0;
    private String _indentString = "\t";
    private HashMap<String, String> _attributes = new LinkedHashMap<String, String>();

    public XMLWriter(Writer writer) {
        this._writer = writer;
    }

    public XMLWriter(OutputStream outputStream) {
        try {
            this._charEncoding = "UTF-8";
            this._writer = new OutputStreamWriter(outputStream, this._charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 character encoding not supported on this platform");
        }
    }

    public XMLWriter(OutputStream outputStream, String charEncoding) throws UnsupportedEncodingException {
        this._charEncoding = charEncoding;
        this._writer = new OutputStreamWriter(outputStream, this._charEncoding);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this._prettyPrint = prettyPrint;
    }

    public boolean prettyPrintEnabled() {
        return this._prettyPrint;
    }

    public void setIndentString(String indentString) {
        this._indentString = indentString;
    }

    public String getIndentString() {
        return this._indentString;
    }

    public void startDocument() throws IOException {
        this._write("<?xml version='1.0'");
        if (this._charEncoding != null) {
            this._write(" encoding='" + this._charEncoding + "'");
        }
        this._writeLn("?>");
    }

    public void endDocument() throws IOException {
        this._writer.flush();
    }

    public void setAttribute(String name, String value) {
        this._attributes.put(name, value);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void startTag(String elName) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._writeLn(">");
        ++this._indentLevel;
    }

    public void endTag(String elName) throws IOException {
        --this._indentLevel;
        this._writeIndent();
        this._writeLn("</" + elName + ">");
    }

    public void emptyElement(String elName) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._writeLn("/>");
    }

    public void writeStylesheet(String url) throws IOException {
        this._write("<?xml-stylesheet type='text/xsl' href='");
        this.text(url);
        this._writeLn("'?>");
    }

    public void textElement(String elName, String text) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._write(">");
        this.text(text);
        this._writeLn("</" + elName + ">");
    }

    public void unescapedTextElement(String elName, String text) throws IOException {
        this._writeIndent();
        this._write("<" + elName);
        this._writeAtts();
        this._write(">");
        this._write(text);
        this._writeLn("</" + elName + ">");
    }

    public void textElement(String elName, int value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void textElement(String elName, boolean value) throws IOException {
        this.textElement(elName, String.valueOf(value));
    }

    public void text(String text) throws IOException {
        this._write(XMLUtil.escapeCharacterData(text));
    }

    public void comment(String comment) throws IOException {
        this._writeIndent();
        this._writeLn("<!-- " + comment + " -->");
    }

    public void emptyLine() throws IOException {
        this._writeLn("");
    }

    private void _writeAtts() throws IOException {
        for (Map.Entry<String, String> entry : this._attributes.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            this._write(" " + name + "='");
            if (value != null) {
                this._write(XMLUtil.escapeSingleQuotedAttValue(value));
            }
            this._write("'");
        }
        this._attributes.clear();
    }

    protected void _write(String s) throws IOException {
        this._writer.write(s);
    }

    protected void _writeLn(String s) throws IOException {
        this._write(s);
        if (this._prettyPrint) {
            this._write(LINE_SEPARATOR);
        }
    }

    protected void _writeIndent() throws IOException {
        if (this._prettyPrint) {
            for (int i = 0; i < this._indentLevel; ++i) {
                this._write(this._indentString);
            }
        }
    }

    private static final class XMLUtil {
        private XMLUtil() {
        }

        public static String escapeSingleQuotedAttValue(String value) {
            value = XMLUtil._escapeAttValue(value);
            value = StringUtils.replace((String)value, (String)"'", (String)"&apos;");
            return value;
        }

        private static String _escapeAttValue(String value) {
            value = StringUtils.replace((String)value, (String)"&", (String)"&amp;");
            value = StringUtils.replace((String)value, (String)"<", (String)"&lt;");
            value = StringUtils.replace((String)value, (String)">", (String)"&gt;");
            value = StringUtils.replace((String)value, (String)"\t", (String)"&#x9;");
            value = StringUtils.replace((String)value, (String)"\n", (String)"&#xA;");
            value = StringUtils.replace((String)value, (String)"\r", (String)"&#xD;");
            return value;
        }

        public static String escapeCharacterData(String text) {
            StringBuilder aSB = new StringBuilder();
            for (int j = 0; j < text.length(); ++j) {
                char c = text.charAt(j);
                if (c == '\r') {
                    aSB.append("&#xD;");
                    continue;
                }
                if (c < '\t' || c > '\n' && c < ' ' || c == '\u007f') {
                    aSB.append(String.format("\\u%04d", c));
                    continue;
                }
                if (c == '&') {
                    aSB.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    aSB.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    aSB.append("&gt;");
                    continue;
                }
                aSB.append(c);
            }
            return aSB.toString();
        }
    }
}

