/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.QueryResultHandlerException;
import com.stardog.stark.query.io.xml.SPARQLXMLConstants;
import com.stardog.stark.query.io.xml.SimpleSAXAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;

final class SPARQLResultsSAXParser
extends SimpleSAXAdapter
implements SPARQLXMLConstants {
    private List<String> bindingNames;
    private String currentBindingName;
    private Value currentValue;
    private Resource subject;
    private IRI predicate;
    private Value object;
    private Resource context = Values.DEFAULT_GRAPH;
    private BindingSets.Builder currentSolution;
    private SelectQueryResultHandler handler;

    public SPARQLResultsSAXParser(@Nonnull SelectQueryResultHandler handler) {
        this.handler = handler;
    }

    @Override
    public void startDocument() throws SAXException {
        this.bindingNames = new ArrayList<String>();
        this.currentValue = null;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.handler != null) {
                this.handler.end();
            }
        }
        catch (QueryResultHandlerException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void startTag(String theTag, Map<String, String> theAttributes, String theText) throws SAXException {
        if ("binding".equals(theTag)) {
            this.currentBindingName = theAttributes.get("name");
            if (this.currentBindingName == null) {
                throw new SAXException("name attribute missing for binding element");
            }
        } else if ("uri".equals(theTag)) {
            try {
                this.currentValue = Values.iri((String)theText);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e.getMessage(), e);
            }
        } else if ("bnode".equals(theTag)) {
            this.currentValue = Values.bnode((String)theText);
        } else if ("literal".equals(theTag)) {
            String xmlLang = theAttributes.get("xml:lang");
            String datatype = theAttributes.get("datatype");
            if (xmlLang != null) {
                this.currentValue = Values.literal((String)theText, (String)xmlLang);
            } else if (datatype != null) {
                try {
                    this.currentValue = Values.literal((String)theText, (IRI)Values.iri((String)datatype));
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            } else {
                this.currentValue = Values.literal((String)theText);
            }
        } else if ("result".equals(theTag)) {
            this.currentSolution = BindingSets.builder();
        } else if ("variable".equals(theTag)) {
            String varName = theAttributes.get("name");
            if (varName == null) {
                throw new SAXException("name missing for variable element");
            }
            this.bindingNames.add(varName);
        } else if ("results".equals(theTag)) {
            try {
                this.handler.start();
                this.handler.variables(this.bindingNames);
            }
            catch (QueryResultHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        } else if ("boolean".equals(theTag)) {
            throw new SAXException((Exception)new InvalidQueryResults("Found boolean results in tuple parser"));
        }
    }

    @Override
    public void endTag(String theTag) throws SAXException {
        if ("binding".equals(theTag)) {
            if (this.currentValue == null) {
                throw new SAXException("Value missing for binding element");
            }
            this.currentSolution.add(this.currentBindingName, this.currentValue);
            this.currentBindingName = null;
            this.currentValue = null;
        } else if ("result".equals(theTag)) {
            try {
                this.handler.handle((Object)this.currentSolution.build());
                this.currentSolution = null;
            }
            catch (QueryResultHandlerException e) {
                throw new SAXException((Exception)((Object)e));
            }
        } else if ("s".equals(theTag)) {
            this.subject = (Resource)this.currentValue;
        } else if ("p".equals(theTag)) {
            this.predicate = (IRI)this.currentValue;
        } else if ("o".equals(theTag)) {
            this.object = this.currentValue;
        } else if ("g".equals(theTag)) {
            this.context = (Resource)this.currentValue;
        } else if ("statement".equals(theTag)) {
            this.currentValue = Values.statement((Resource)this.subject, (IRI)this.predicate, (Value)this.object, (Resource)this.context);
            this.subject = null;
            this.predicate = null;
            this.object = null;
            this.context = Values.DEFAULT_GRAPH;
        }
    }
}

