/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import com.complexible.common.base.Options;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.QueryResultParser;
import com.stardog.stark.query.io.xml.SPARQLXMLParserOptions;
import com.stardog.stark.query.io.xml.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class SAXErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryResultParser.class);
    private final Options mOptions;
    private final SimpleSAXParser mParser;

    public SAXErrorHandler(Options theOptions, SimpleSAXParser theParser) {
        this.mOptions = theOptions;
        this.mParser = theParser;
    }

    @Override
    public void warning(SAXParseException theException) throws SAXException {
        LOGGER.warn(theException.toString());
    }

    @Override
    public void error(SAXParseException theException) throws SAXException {
        if (this.mOptions.is(SPARQLXMLParserOptions.FAIL_ON_SAX_NON_FATAL_ERRORS)) {
            this.fatalError(theException);
        } else {
            this.warning(theException);
        }
    }

    @Override
    public void fatalError(SAXParseException theException) throws SAXException {
        throw new InvalidQueryResults(theException.toString(), this.mParser.getLocator() != null ? (long)this.mParser.getLocator().getLineNumber() : -1L, this.mParser.getLocator() != null ? (long)this.mParser.getLocator().getColumnNumber() : -1L);
    }
}

