/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.xml;

import com.complexible.common.base.Options;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterOptions;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.xml.SPARQLXMLConstants;
import com.stardog.stark.query.io.xml.XMLWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractSPARQLXMLWriter<T>
implements QueryResultWriter<T>,
SPARQLXMLConstants {
    protected final XMLWriter mWriter;
    protected final Options mOptions;
    protected boolean documentOpen = false;
    protected boolean headerOpen = false;
    protected boolean headerComplete = false;
    protected boolean tupleVariablesFound = false;
    protected final NamespacesImpl mNamespaces = new NamespacesImpl();

    public AbstractSPARQLXMLWriter(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
        this.mWriter = new XMLWriter(theOutputStream);
        this.mWriter.setPrettyPrint(theOptions.is(QueryResultWriterOptions.PRETTY_PRINT));
        this.mOptions = theOptions;
    }

    public final void links(@Nonnull List<String> theLinks) throws ResultWritingFailed {
        if (!this.documentOpen) {
            this.start();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        try {
            for (String name : theLinks) {
                this.mWriter.setAttribute("href", name);
                this.mWriter.emptyElement("link");
            }
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    void startHeader() throws ResultWritingFailed {
        if (!this.documentOpen) {
            this.start();
        }
        if (!this.headerOpen) {
            try {
                this.mWriter.startTag("sparql");
                this.mWriter.startTag("head");
                this.headerOpen = true;
            }
            catch (IOException e) {
                throw new ResultWritingFailed((Throwable)e);
            }
        }
    }

    void endHeader() throws ResultWritingFailed {
        if (!this.documentOpen) {
            this.start();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            try {
                this.mWriter.endTag("head");
                if (this.tupleVariablesFound) {
                    this.mWriter.startTag("results");
                }
                this.headerComplete = true;
            }
            catch (IOException e) {
                throw new ResultWritingFailed((Throwable)e);
            }
        }
    }

    public final void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) throws ResultWritingFailed {
        this.mNamespaces.add(thePrefix, theIRI);
    }

    public final void start() throws ResultWritingFailed {
        if (!this.documentOpen) {
            this.documentOpen = true;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            try {
                this.mWriter.setPrettyPrint(this.mOptions.is(QueryResultWriterOptions.PRETTY_PRINT));
                if (this.mOptions.is(QueryResultWriterOptions.INCLUDE_XML_PI)) {
                    this.mWriter.startDocument();
                }
                this.mWriter.setAttribute("xmlns", "http://www.w3.org/2005/sparql-results#");
                this.mNamespaces.forEach(ns -> this.mWriter.setAttribute("xmlns:" + ns.prefix(), ns.iri()));
            }
            catch (IOException e) {
                throw new ResultWritingFailed((Throwable)e);
            }
        }
    }

    public final void end() throws ResultWritingFailed {
        try {
            if (!this.documentOpen) {
                this.start();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (this.tupleVariablesFound) {
                this.mWriter.endTag("results");
            }
            this.mWriter.endTag("sparql");
            this.mWriter.endDocument();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }
}

