/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.logging.cli;

import com.brsanthu.dataexporter.DataExporter;
import com.brsanthu.dataexporter.output.csv.CsvExportOptions;
import com.brsanthu.dataexporter.output.csv.CsvExporter;
import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Pair;
import com.complexible.common.collect.SortedIterators;
import com.complexible.common.dataexporter.LogJsonOuput;
import com.complexible.common.dataexporter.LogOutputter;
import com.complexible.common.dataexporter.TableExporter;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.dataexporter.WordWrapStringColumn;
import com.complexible.common.io.TailInputStream;
import com.complexible.stardog.KernelEvent;
import com.complexible.stardog.KernelEventLogging;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.StardogCommand;
import com.complexible.stardog.logging.JsonLogReader;
import com.complexible.stardog.logging.LogReader;
import com.complexible.stardog.logging.protobuf.ProtobufLogReader;
import com.complexible.stardog.logging.protobuf.ProtobufTextLogReader;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;

@Command(name="print", description="Prints the contents of an access or audit log. A log is a sequence of events where each event has a type, timestamp, user, ip, flags, and an optional value.", examples={"* Print all the events in the log file", "    $ stardog-admin log print access.log", "", "* Print all the events but show only the specified fields", "    $ stardog-admin log print --field time user database query -- access.log", "", "* Print only query events for the databases matching the regular expression that occurred in a specific time interval", "    $ stardog-admin log print --filter event=query database~customer.* time>=2014-01-06 time<=2014-01-07 -- audit.log"})
public final class LogPrint
implements StardogCommand<Void> {
    @Arguments(required=true, description="The log file(s) to print", title={"log file"})
    public List<File> mFiles = Lists.newArrayList();
    @Option(name={"--text"}, description="Used to indicate that the log file is in text protobuf format. By default logs are expected to be in JSON format.", title="text", arity=0)
    public boolean mText = false;
    @Option(name={"--binary"}, description="Used to indicate that the log file is in binary protobuf format. By default logs are expected to be in JSON format.", title="binary", arity=0)
    public boolean mBinary = false;
    @Option(name={"--json-input"}, description="Deprecated. Logs are expected to be in JSON format by default.", title="json input", arity=0, hidden=true)
    public boolean mJsonInput = false;
    @Option(name={"--json"}, description="Display results in JSON.", title="json", arity=0)
    public boolean mJson = false;
    @Option(name={"-f", "--field"}, description="Fields to include in the output. Allowed values are: {Time, Event, Database, User, IP, Value, Query, Flags}", title="field", arity=0x7FFFFFFF)
    public List<String> mFieldNames;
    @Option(name={"--filter"}, description="Filter expressions to hide certain events. A filter expression is in the form 'field op value' where field is one of the fields defined in --field option, op is one of '=', '<', '<=', '>', '>=', or '~', and value should be a valid value for the field. For example,filter expression for time field should use xsd:date or xsd:dateTime values. The op '~' represents regular expression matching where value should be a valid Java regular expression and should match the entire value of the given field. Valid values for event field are: { AddRole, AddUser, AddUserRole, Authentication, Backup, ChangePassword, ChangeUserEnabled, ConnectionClose, ConnectionOpen, Copy, CreateDatabase, DataAdd, DataRemove, DataRemoveAll, DataRemoveContext, DeleteRole, DeleteUser, DeleteUserRole, DropDatabase, GetEffectiveUserPermissions, GetEnabledStatus, GetOption, GetRolePermissions, GetSuperStatus, GetUserPermissions, GetUserRoles, GetUsersWithRole, ListRoles, ListUsers, Migrate, Offline, Online, Optimize, Query, QueryEnd, Repair, Restore, RolePermissionGrant, RolePermissionRevoke, SetEnabledStatus, SetOption, SetSuperStatus, SetUserRoles, Shutdown, Startup, StoredQueryAdded, StoredQueryRemoved, StoredQueryUpdated, TxBegin, TxCommit, TxRollback, UserPermissionGrant, UserPermissionRevoke, WildcardPermissionRevoke }", title="filter", arity=0x7FFFFFFF)
    public List<String> mFilters = Lists.newArrayList();
    @Option(name={"-d", "--delimeter"}, description="Delimiter to use for separating fields in the output. By default the output is printed in a tabular format but this option can be used to output in CSV or TSV format.", title="delimeter")
    public String mDelimeter = null;
    @Option(name={"--tail"}, description="Wait for new events to be logged and print them as they are logged.", title="tail", arity=0)
    public boolean mTail = false;
    @Option(name={"-n", "--lines"}, description="The number of lines to output from the bottom of the file.  -1 is the default and means every line.", title="lines")
    public int mLines = -1;
    private Queue<Object[]> mBacklogRows = null;
    private LogOutputter mExporter;

    @Inject
    public LogPrint() {
    }

    public Void call() throws Exception {
        KernelEventLogging.Field[] aFields = this.createFields();
        this.mExporter = this.createExporter(aFields);
        Predicate<KernelEvent<?>> aFilter = this.parseFilters();
        if (this.mTail) {
            if (this.mFiles.size() > 1) {
                throw new CliException("Option --tail cannot be used with multipel files");
            }
            this.mExporter.setPrefetchLimit(0);
            if (this.mLines >= 0) {
                this.mBacklogRows = EvictingQueue.create((int)this.mLines);
            }
        }
        Object[] aRow = new Object[aFields.length];
        try (CloseableIterator<Pair<File, KernelEvent>> aEvents = this.readEvents();){
            while (aEvents.hasNext()) {
                Pair aPair = (Pair)aEvents.next();
                KernelEvent aEvent = (KernelEvent)aPair.second;
                if (!aFilter.test(aEvent)) continue;
                for (int i = 0; i < aFields.length; ++i) {
                    aRow[i] = LogPrint.getFormattedField((Pair<File, KernelEvent>)aPair, aFields[i]);
                }
                if (this.mBacklogRows != null) {
                    this.mBacklogRows.add(aRow);
                    continue;
                }
                this.mExporter.addRow(aRow);
            }
            this.mExporter.output();
        }
        return null;
    }

    private Boolean streamEof() {
        if (this.mBacklogRows != null) {
            this.mBacklogRows.forEach(r -> this.mExporter.addRow(r));
            this.mBacklogRows = null;
        }
        return false;
    }

    private KernelEventLogging.Field[] createFields() {
        KernelEventLogging.Field[] aFields;
        if (this.mFieldNames == null) {
            EnumSet<KernelEventLogging.Field> aFieldsToExclude = EnumSet.of(KernelEventLogging.Field.QUERY);
            if (this.mFiles.size() == 1) {
                aFieldsToExclude.add(KernelEventLogging.Field.FILE);
            }
            aFields = EnumSet.complementOf(aFieldsToExclude).toArray(new KernelEventLogging.Field[0]);
        } else {
            aFields = new KernelEventLogging.Field[this.mFieldNames.size()];
            for (int i = 0; i < aFields.length; ++i) {
                aFields[i] = KernelEventLogging.getField((String)this.mFieldNames.get(i).toUpperCase());
            }
        }
        return aFields;
    }

    private LogOutputter createExporter(KernelEventLogging.Field[] theFields) {
        if (this.mJson) {
            List fieldName = Arrays.stream(theFields).map(f -> f.name()).collect(Collectors.toList());
            return new LogJsonOuput(System.out, fieldName);
        }
        TableExporter aExporter = this.mDelimeter == null ? new TableExporter((OutputStream)System.out) : new CsvExporter(this.createExportOptions());
        return new TextTabularOutput((DataExporter)aExporter, Iterables.transform(Arrays.asList(theFields), f -> {
            WordWrapStringColumn c = new WordWrapStringColumn(StringUtils.capitalize((String)f.name().toLowerCase()));
            c.setWidth(this.getFieldWidth((KernelEventLogging.Field)f));
            return c;
        }));
    }

    private CsvExportOptions createExportOptions() {
        CsvExportOptions aOptions = new CsvExportOptions();
        aOptions.setDelimiter(this.mDelimeter);
        aOptions.setNullString("");
        return aOptions;
    }

    private CloseableIterator<Pair<File, KernelEvent>> readEvents() {
        ProtobufLogReader aReader;
        if (this.mBinary && this.mText) {
            throw new CliException("Only one of --text or --binary arguments should be provided");
        }
        Object object = this.mBinary ? new ProtobufLogReader() : (aReader = this.mText ? new ProtobufTextLogReader() : new JsonLogReader());
        if (this.mFiles.size() == 1) {
            return this.readEvents((LogReader)aReader, this.mFiles.get(0));
        }
        Iterable aEvents = Iterables.transform(this.mFiles, arg_0 -> this.lambda$readEvents$3((LogReader)aReader, arg_0));
        return CloseableIterator.toCloseable((Iterator)SortedIterators.union((Iterable)aEvents, Comparator.comparingLong(p -> ((KernelEvent)p.second).getTimestamp())), () -> AutoCloser.close((Iterable)aEvents));
    }

    private CloseableIterator<Pair<File, KernelEvent>> readEvents(LogReader theReader, File theFile) {
        try {
            return CloseableIterator.transform((CloseableIterator)theReader.read(this.createInputStream(theFile.toPath())), theEvent -> Pair.create((Object)theFile, (Object)theEvent));
        }
        catch (IOException e) {
            throw new StardogException((Throwable)e);
        }
    }

    private InputStream createInputStream(Path theFile) throws IOException {
        InputStream aStream = Files.newInputStream(theFile, new OpenOption[0]);
        if (theFile.toString().endsWith(".gz")) {
            aStream = new GZIPInputStream(aStream);
        }
        aStream = new BufferedInputStream(aStream);
        if (this.mTail) {
            aStream = new TailInputStream(aStream, 500L, TimeUnit.MILLISECONDS, this::streamEof);
        }
        return aStream;
    }

    private static String getFormattedField(Pair<File, KernelEvent> thePair, KernelEventLogging.Field theField) {
        return theField == KernelEventLogging.Field.FILE ? ((File)thePair.first).toString() : KernelEventLogging.getFormattedFieldValue((KernelEvent)((KernelEvent)thePair.second), (KernelEventLogging.Field)theField);
    }

    private int getFieldWidth(KernelEventLogging.Field theField) {
        switch (theField) {
            case FILE: {
                return 30;
            }
            case TIME: {
                return 30;
            }
            case EVENT: {
                return 20;
            }
            case DATABASE: {
                return 20;
            }
            case USER: {
                return 20;
            }
            case IP: {
                return 24;
            }
            case VALUE: {
                return 72;
            }
            case QUERY: {
                return 72;
            }
            case FLAGS: {
                return 10;
            }
        }
        throw new AssertionError((Object)("Invalid field " + String.valueOf(theField)));
    }

    private Predicate<KernelEvent<?>> parseFilters() {
        Predicate<KernelEvent<?>> aFilter = e -> true;
        for (String aFilterStr : this.mFilters) {
            aFilter = aFilter.and(this.parseFilter(aFilterStr));
        }
        return aFilter;
    }

    private Filter parseFilter(String theFilter) {
        for (FilterType aFilterType : FilterType.values()) {
            if (!theFilter.contains(aFilterType.toString())) continue;
            String[] aArgs = theFilter.split(aFilterType.toString());
            KernelEventLogging.Field aField = KernelEventLogging.getField((String)aArgs[0].trim().toUpperCase());
            String aValue = aFilterType == FilterType.REGEX ? aArgs[1].trim() : KernelEventLogging.parseFieldValue((KernelEventLogging.Field)aField, (String)aArgs[1].trim());
            return new Filter(aField, aFilterType, aValue);
        }
        throw new IllegalArgumentException("Invalid filter expression: " + theFilter);
    }

    private /* synthetic */ CloseableIterator lambda$readEvents$3(LogReader aReader, File aFile) {
        return this.readEvents(aReader, aFile);
    }

    private static class Filter
    implements Predicate<KernelEvent<?>> {
        private final KernelEventLogging.Field field;
        private final FilterType type;
        private final Object value;

        private Filter(KernelEventLogging.Field theField, FilterType theType, Object theValue) {
            this.field = theField;
            this.type = theType;
            this.value = theValue;
        }

        @Override
        public boolean test(KernelEvent<?> event) {
            return this.type.test(KernelEventLogging.getFieldValue(event, (KernelEventLogging.Field)this.field), this.value);
        }
    }

    private static enum FilterType {
        NE("!="),
        LE("<="),
        LT("<"),
        GE(">="),
        GT(">"),
        EQ("="),
        REGEX("~");

        private final String op;

        private FilterType(String op) {
            this.op = op;
        }

        public boolean test(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Iterable && this != REGEX) {
                left = Iterables.getFirst((Iterable)((Iterable)left), (Object)left);
            }
            switch (this.ordinal()) {
                case 5: {
                    return left.equals(right);
                }
                case 0: {
                    return !left.equals(right);
                }
                case 2: {
                    return ((Comparable)left).compareTo(right) < 0;
                }
                case 1: {
                    return ((Comparable)left).compareTo(right) <= 0;
                }
                case 4: {
                    return ((Comparable)left).compareTo(right) > 0;
                }
                case 3: {
                    return ((Comparable)left).compareTo(right) >= 0;
                }
                case 6: {
                    return left.toString().matches(right.toString());
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return this.op;
        }
    }
}

