/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.cli;

import com.complexible.stardog.ContextSets;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.cli.ICVWithFiles;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import io.airlift.command.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ICVWithOptionalConstraints
extends ICVWithFiles {
    @Option(name={"-g", "--named-graph", "--named-graphs"}, arity=0x7FFFFFFF, title="named graph(s)", description="The list of contexts which should be validated, if none are specified, the entire database is validated wrt to the provided constraint(s).")
    public List<String> mContexts;
    @Option(name={"-r", "--reasoning"}, description="Turn reasoning on with the default schema.")
    public boolean mReasoningEnabled = false;
    @Option(name={"--schema"}, description="Turn reasoning on with the specified schema.")
    public String mSchema = Schemas.NULL;

    public ICVWithOptionalConstraints(PasswordReader theReader) {
        super(theReader);
    }

    protected Set<Constraint> getConstraints(Iterable<Namespace> namespaces) throws StardogException {
        HashSet aConstraints = Sets.newHashSet();
        ArrayList aFiles = Lists.newArrayList();
        if (this.mFiles != null) {
            aFiles.addAll(this.mFiles);
        }
        if (!aFiles.isEmpty()) {
            for (File aFile : aFiles) {
                aConstraints.addAll(this.readConstraints(aFile.toPath(), namespaces));
            }
            if (aConstraints.isEmpty()) {
                throw new CliException(ICVWithOptionalConstraints.get((String)"icv.error.emptyconstraintsfile", (Object[])new Object[]{aFiles.get(0)}));
            }
        }
        return aConstraints;
    }

    protected Set<IRI> getActiveGraphs(Iterable<Namespace> namespaces) throws StardogException {
        boolean aHasContexts = this.mContexts != null && !this.mContexts.isEmpty();
        return aHasContexts ? CliUtil.readIRIs(this.mContexts, namespaces) : ContextSets.LOCAL;
    }

    protected Set<IRI> getShapeGraphs(Set<IRI> shapeGraphs) throws StardogException {
        return shapeGraphs.isEmpty() ? ContextSets.LOCAL : shapeGraphs;
    }

    protected String getReasoningSchema() {
        return this.mSchema == null && this.mReasoningEnabled ? "default" : this.mSchema;
    }
}

