/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.cli;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.IO;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ConstraintFactory;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import io.airlift.command.Option;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;

public abstract class ICVWithFiles
extends ConnectionCommand<Void> {
    @Option(name={"-f", "--format"}, description="RDF Format [N-TRIPLES, RDF/XML, TURTLE, TRIG] for the constraints.", title="format")
    public String mFormat;
    protected List<File> mFiles = null;
    protected String mDbName = null;

    @Inject
    public ICVWithFiles(PasswordReader theReader) {
        super(theReader);
    }

    protected void initArgs(List<String> theArgs) {
        if (theArgs != null && !theArgs.isEmpty()) {
            this.mDbName = theArgs.get(0);
            if (theArgs.size() > 1) {
                this.mFiles = Lists.newArrayList();
                for (int i = 1; i < theArgs.size(); ++i) {
                    this.mFiles.add(new File(theArgs.get(i)));
                }
            }
        }
    }

    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        this.initArgs(this.getArgs());
        return this.mDbName;
    }

    protected abstract List<String> getArgs();

    protected Set<Constraint> readConstraints(Path theConstraintsFile, Iterable<Namespace> namespaces) throws StardogException {
        return this.readConstraints(theConstraintsFile, null, namespaces);
    }

    private Set<Constraint> readConstraints(Path theConstraintsFile, IO theIO, Iterable<Namespace> namespaces) throws StardogException {
        RDFFormat aFormat = null;
        boolean aIsFormat = !Strings.isNullOrEmpty((String)this.mFormat);
        aFormat = !aIsFormat ? RDFFormats.forFile((String)theConstraintsFile.toFile().getName(), null) : CliUtil.getFormat((String)this.mFormat);
        if (aFormat == null) {
            throw new IllegalArgumentException("Cannot find a parser for " + String.valueOf(theConstraintsFile) + (String)(this.mFormat == null ? "" : " with format " + this.mFormat));
        }
        try {
            Set aConstraints = null;
            if (theIO != null) {
                theIO.format(aFormat).file(theConstraintsFile);
            } else {
                try (InputStream aStream = Files.newInputStream(theConstraintsFile, new OpenOption[0]);){
                    Set graph = RDFParsers.read((InputStream)aStream, (RDFFormat)aFormat, (Options)ParserOptions.namespaces(namespaces));
                    aConstraints = ConstraintFactory.constraints((Iterable)graph);
                }
            }
            return aConstraints;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new CliException(ICVWithFiles.get((String)"icv.error.noconstraintsfilefound", (Object[])new Object[]{theConstraintsFile}));
        }
        catch (InvalidRDF | IOException e) {
            throw new CliException(ICVWithFiles.get((String)"icv.error.problemswithreadingconstraintsfile", (Object[])new Object[]{String.valueOf(theConstraintsFile) + ": " + String.valueOf(e)}));
        }
    }
}

