/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.cli;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.CloseableIterator;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.api.ICVConnection;
import com.complexible.stardog.icv.cli.ICVWithOptionalConstraints;
import com.complexible.stardog.icv.shacl.validator.ShaclUtils;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriters;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

@Command(name="validate", description="Integrity Constraint Validate command that supports validating the database (or a subset of it via named graphs) with existing or new constraints. New constraints should be specified as arguments passed at the end. If no new constraints are given then the constraints stored in the database will be used.", examples={"* Validate the database:", "    $ stardog icv validate myDb", "", "* Validate only the specified named graphs:", "    $ stardog icv validate --named-graphs http://example.org/graph1 http://example.org/graph2 -- myDb"})
public final class ICVValidate
extends ICVWithOptionalConstraints {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Then optionally the list of files which contain Integrity Constraints.", title={"dbname", "constraint_files"})
    public List<String> mArgs;

    @Inject
    public ICVValidate(PasswordReader theReader) {
        super(theReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection theConn) throws StardogException {
        CloseableIterator aIter;
        block3: {
            ICVConnection aConn = (ICVConnection)theConn.as(ICVConnection.class);
            NamespacesInfo aNamespaces = theConn.namespaces();
            aIter = null;
            try {
                boolean isValid;
                Set<Constraint> aConstraints = this.getConstraints((Iterable<Namespace>)aNamespaces);
                Set<IRI> theActiveGraph = this.getActiveGraphs((Iterable<Namespace>)aNamespaces);
                aIter = aConstraints.isEmpty() ? aConn.getViolationBindings(theActiveGraph, new Constraint[0]) : aConn.getViolationBindings(theActiveGraph, (Constraint[])Iterables.toArray(aConstraints, Constraint.class));
                boolean bl = isValid = !aIter.hasNext();
                if (isValid) {
                    System.out.println(ICVValidate.get((String)"icv.msg.valid", (Object[])new Object[0]));
                    break block3;
                }
                System.out.println(ICVValidate.get((String)"icv.msg.invalid", (Object[])new Object[0]));
                System.out.println(ICVValidate.get((String)"icv.msg.violations", (Object[])new Object[0]));
                SelectQueryResultWriter aWriter = QueryResultWriters.to((OutputStream)System.out, (QueryResultFormat)QueryResultFormats.TEXT_TABLE).map(SelectQueryResultWriter.class::cast).orElseThrow(() -> new CliException("Serializer not found"));
                aWriter.start();
                aWriter.variables(ShaclUtils.VALIDATE_SERVICE_VARS);
                aIter.forEachRemaining(arg_0 -> ((SelectQueryResultWriter)aWriter).handle(arg_0));
                aWriter.end();
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{aIter});
                throw throwable;
            }
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{aIter});
    }

    @Override
    protected List<String> getArgs() {
        return this.mArgs;
    }
}

