/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cache.api.CacheConnectionOptions;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.icv.ValidationOptions;
import com.complexible.stardog.icv.api.ICVConnection;
import com.complexible.stardog.icv.cli.ICVWithOptionalConstraints;
import com.complexible.stardog.icv.shacl.SHACL;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import com.stardog.stark.impl.ImmutableNamespaces;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

@Command(name="report", description="Integrity Constraint Validate command that validates SHACL constraints and generates a SHACL validation report as defined in the SHACL specification.", discussion="Integrity Constraint Validate command that validates SHACL constraints and generates a SHACL validation report as defined in the SHACL specification. Note that if there are other constraints in the database they will not be validated by this command.", examples={"* Validate the SHACL constraints already loaded to the database:", "    $ stardog icv report myDb", "", "* Validate only the specified named graphs:", "    $ stardog icv report --named-graphs http://example.org/graph1 http://example.org/graph2 -- myDb"})
public final class ICVReport
extends ICVWithOptionalConstraints {
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_LIMIT_PER_SHAPE = 10;
    @Option(name={"--output-format"}, description="Output RDF Format for the validation report. One of [NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD]", title="Output Format")
    public String mOutputFormat = RDFFormats.PRETTY_TURTLE.name();
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Then optionally the list of files which contain SHACL Constraints.", title={"dbname", "constraint_files"})
    public List<String> mArgs;
    @Option(name={"-l", "--limit"}, title="limit", description="Limits the total number of validation results returned. If a limit of '-1' is specified, all validation results will be returned. The default limit is 100 if --limit-per-shapeis not specified; otherwise limit will be set to '-1'. Note that, each validation result will be serialized using multiple triples so the number of triples in the report might be higher than this limit.")
    public Integer mLimit = null;
    @Option(name={"--limit-per-shape"}, description="Limits the number of violations returned per shape. The default value is 10 if --limit option is not specified, otherwise the --limit value is used. This option is introduced for ease of readability of the report on the types of different violations")
    public Integer mViolationLimitPerShape = null;
    @Option(name={"--nodes"}, arity=0x7FFFFFFF, title="nodes", description="The list of node IRIs that should be validated, if none are specified, all the nodes in the database are validated.")
    public List<String> mNodes = Lists.newArrayList();
    @Option(name={"--shapes"}, arity=0x7FFFFFFF, title="shapes", description="The list of shape IRIs that should be validated, if none are specified, all the SHACL shapes will be validated.")
    public List<String> mShapes = Lists.newArrayList();
    @Option(name={"--shape-graphs"}, arity=0x7FFFFFFF, title="shape graphs", description="The list of constraint context IRIs those could be leveraged to apply validation with constraints having those contexts as groups.")
    public List<String> mShapeGraphs = Lists.newArrayList();
    @Option(name={"--simple-target"}, description="If true, sh:targetClass will be evaluated based on rdf:type triples only, without following rdfs:subClassOf relations.")
    public boolean simpleTarget = false;
    @Option(name={"--skip-cache"}, description="If true, do not check if there's a cache node containing the graph to be validated. Takes effect only if a named graph has been specified with the -g/--named-graph option.")
    public boolean mSkipCache = false;

    @Inject
    public ICVReport(PasswordReader theReader) {
        super(theReader);
    }

    public void execute(Connection theConn) throws StardogException {
        if (this.mLimit == null) {
            if (this.mViolationLimitPerShape == null) {
                this.mLimit = 100;
                this.mViolationLimitPerShape = 10;
            } else {
                this.mLimit = -1;
            }
        } else if (this.mViolationLimitPerShape == null) {
            this.mViolationLimitPerShape = this.mLimit;
        }
        ICVConnection conn = (ICVConnection)theConn.as(ICVConnection.class);
        List<Namespace> namespaces = ICVReport.getShaclNamespaceList(Lists.newArrayList((Iterable)theConn.namespaces()));
        RDFWriter aWriter = (RDFWriter)RDFWriters.to((OutputStream)System.out, (RDFFormat)CliUtil.getFormat((String)this.mOutputFormat), (Iterable)new ImmutableNamespaces(namespaces)).get();
        aWriter.start();
        ((ICVConnection)conn.as(ICVConnection.class)).reporter().countLimit(this.mLimit.intValue()).graphs(this.getActiveGraphs(namespaces)).shapeGraphs(this.getShapeGraphs(CliUtil.readIRIs(this.mShapeGraphs, namespaces))).constraints(this.getConstraints(namespaces)).shapes((Collection)CliUtil.readIRIs(this.mShapes, namespaces)).nodes((Collection)CliUtil.readIRIs(this.mNodes, namespaces)).option(ValidationOptions.TARGET_CLASS_SIMPLE, (Object)this.simpleTarget).option(CacheConnectionOptions.CACHING_ENABLED, (Object)(!this.mSkipCache ? 1 : 0)).option(ValidationOptions.COUNT_LIMIT_PER_SHAPE, (Object)this.mViolationLimitPerShape).report((RDFHandler)aWriter);
        aWriter.end();
    }

    @Override
    protected List<String> getArgs() {
        return this.mArgs;
    }

    private static List<Namespace> getShaclNamespaceList(List<Namespace> namespaces) {
        if (!namespaces.stream().anyMatch(ns -> ns.iri().equals(SHACL.namespace))) {
            namespaces.add(Values.namespace((String)"sh", (String)"http://www.w3.org/ns/shacl#"));
        }
        return namespaces;
    }
}

