/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv.cli;

import com.complexible.common.rdf.StatementSource;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ICV;
import com.complexible.stardog.icv.api.ICVConnection;
import com.complexible.stardog.icv.cli.ICVWithFiles;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.stardog.stark.Namespaces;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Command(name="export", description="Exports constraints in the given Stardog database.")
public final class ICVExport
extends ICVWithFiles {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. Then optionally the name of the output file.", title={"dbname", "constraint_files"})
    public List<String> mArgs;

    @Inject
    public ICVExport(PasswordReader theReader) {
        super(theReader);
    }

    public void execute(Connection theConn) throws StardogException {
        PrintStream aOutput = this.getOutput();
        ICVConnection aConn = (ICVConnection)theConn.as(ICVConnection.class);
        Set aConstraints = aConn.getConstraints();
        if (aConstraints.isEmpty()) {
            throw new CliException(ICVExport.get((String)"icv.error.emptyconstraintsdb", (Object[])new Object[]{this.mDbName}));
        }
        if (Strings.isNullOrEmpty((String)this.mFormat) && this.mFiles != null && !this.mFiles.isEmpty()) {
            RDFFormat aFormat = RDFFormats.forFile((String)((File)this.mFiles.get(0)).getName(), null);
            this.mFormat = aFormat.defaultMimeType();
        }
        Namespaces aNamespaces = CliUtil.namespaces((Connection)theConn);
        if (Strings.isNullOrEmpty((String)this.mFormat) || this.mFormat.equalsIgnoreCase("TEXT") || this.mFormat.equalsIgnoreCase("text/plain")) {
            for (Constraint aConstraint : aConstraints) {
                aOutput.println(aConstraint.toString(aNamespaces));
            }
        } else {
            RDFFormat aFormat = CliUtil.getFormat((String)this.mFormat);
            if (aFormat == null) {
                throw new IllegalArgumentException("Cannot find a parser for format " + this.mFormat);
            }
            try (StatementSource aSource = ICV.constraintsToSource((Iterable)aConstraints);){
                CliUtil.writeGraph((Iterator)aSource.statements(), (RDFFormat)aFormat, (Iterable)aNamespaces, (OutputStream)aOutput);
            }
            catch (Exception e) {
                throw new CliException((Throwable)e);
            }
        }
    }

    private PrintStream getOutput() throws StardogException {
        if (this.mFiles == null || this.mFiles.isEmpty()) {
            return System.out;
        }
        File mFile = (File)this.mFiles.get(0);
        try {
            return new PrintStream(Files.newOutputStream(mFile.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    protected List<String> getArgs() {
        return this.mArgs;
    }
}

