/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.pack.cli.ZkClientCommand;
import com.complexible.stardog.pack.replication.impl.zookeeper.ZKUtils;
import io.airlift.command.Command;
import org.apache.curator.framework.CuratorFramework;

@Command(name="info", description="Prints the data Stardog stores in a ZooKeeper cluster.", discussion="This command connects to a Zookeeper cluster and prints the data stored by Stardog.", examples={"* Connects to a Zookeeper at the given address and prints the data:", "    $ stardog-admin zk info 127.0.0.1:2180", "", "* Connects to a Zookeeper at the given address with the given authentication string and prints the data:", "    $ stardog-admin zk info --zkauth my_secret_key 127.0.0.1:2180", "", "* Read the Zookeeper address and the authentication string from stardog.properties in the specified home directory:", "    $ stardog-admin zk info --home stardog_home_path", "", "* Read the Zookeeper address and the authentication string from stardog.properties in $STARDOG_HOME:", "    $ stardog-admin zk info", ""})
public final class ZkInfo
extends ZkClientCommand {
    @Override
    protected void execute(CuratorFramework framework) throws Exception {
        boolean rootExists;
        String root = "/stardog/cluster/4.3";
        boolean bl = rootExists = framework.checkExists().forPath("/stardog/cluster/4.3") != null;
        if (!rootExists) {
            throw new CliException(ZkInfo.get((String)"zk.info.fail", (Object[])new Object[0]));
        }
        System.out.println(ZKUtils.getTree((CuratorFramework)framework, (String)"/stardog/cluster/4.3", (String)"/", (String)""));
    }
}

