/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.common.base.Options;
import com.complexible.common.util.EnhancedProperties;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.impl.AbstractStardogCommand;
import com.complexible.stardog.pack.replication.ClusterOptions;
import com.complexible.stardog.pack.replication.impl.zookeeper.ConfiguredCuratorFactory;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Option;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkClientCommand
extends AbstractStardogCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkClientCommand.class);
    @Option(name={"--zkauth"}, title="auth", description="Zookeeper authentication string. If this value is not provided the value for the configuration option 'pack.zookeeper.auth' from stardog.properties is used. If that value is not set either then the default value 'admin:admin' will be used.")
    public String mAuth = "";
    @Option(name={"--home"}, title="home", description="Stardog home directory location. This is where the stardog.properties file is located at.")
    private String mHome = System.getProperty("stardog.home");
    @Arguments(title={"zkAddress"}, description="Zookeeper connection string. If this value is not provided the value for the configuration option 'pack.zookeeper.auth' from stardog.properties is used.")
    public String mZkConnString = "";
    public static final String PROPERTY_STARDOG_PROPERTIES_FILE = "stardog.properties.file";
    public static final String ENV_STARDOG_PROPERTIES_FILE = "STARDOG_PROPERTIES";

    @Inject
    public ZkClientCommand() {
    }

    public Void call() throws Exception {
        EnhancedProperties aConfig;
        File aHome = new File(this.mHome);
        EnhancedProperties enhancedProperties = aConfig = aHome.exists() ? ZkClientCommand.propsFromFile(aHome) : new EnhancedProperties();
        if (Strings.isNullOrEmpty((String)this.mZkConnString)) {
            this.mZkConnString = aConfig.getProperty(ClusterOptions.ZOOKEEPER_CONN_STRING.getName());
            if (Strings.isNullOrEmpty((String)this.mZkConnString)) {
                throw new CliException(ZkClientCommand.get((String)"zk.conn.missing", (Object[])new Object[0]));
            }
        }
        if (Strings.isNullOrEmpty((String)this.mAuth)) {
            this.mAuth = aConfig.getProperty(ClusterOptions.ZOOKEEPER_AUTH_STRING.getName());
        }
        try (CuratorFramework framework = new ConfiguredCuratorFactory().newCurator(this.mZkConnString, Options.of((com.complexible.common.base.Option)ClusterOptions.ZOOKEEPER_AUTH_STRING, (Object)this.mAuth));){
            this.execute(framework);
        }
        return null;
    }

    protected abstract void execute(CuratorFramework var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static EnhancedProperties propsFromFile(File theSystemDir) {
        EnhancedProperties aProps;
        block11: {
            FileInputStream aStream;
            block10: {
                String aPropFilePath = System.getProperty(PROPERTY_STARDOG_PROPERTIES_FILE, System.getenv(ENV_STARDOG_PROPERTIES_FILE));
                File aFile = aPropFilePath != null ? new File(aPropFilePath) : new File(theSystemDir, "stardog.properties");
                aProps = new EnhancedProperties();
                aStream = null;
                if (!aFile.exists()) break block10;
                aStream = new FileInputStream(aFile);
                aProps.load((InputStream)aStream);
            }
            try {
                Closeables.close(aStream, (boolean)false);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to close the stream which the StardogConfiguration was read from", (Throwable)e);
            }
            break block11;
            catch (IOException e) {
                try {
                    LOGGER.warn("Could not read Stardog configuration", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(aStream, (boolean)false);
                    }
                    catch (IOException e2) {
                        LOGGER.debug("Failed to close the stream which the StardogConfiguration was read from", (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)aStream, (boolean)false);
                }
                catch (IOException e3) {
                    LOGGER.debug("Failed to close the stream which the StardogConfiguration was read from", (Throwable)e3);
                }
            }
        }
        return aProps;
    }
}

