/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.pack.cli.ZkClientCommand;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.curator.framework.CuratorFramework;

@Command(name="clear", description="Clears the data stored in ZooKeeper by the Stardog cluster.", discussion="This command connects to a Zookeeper cluster and clears the data stored by Stardog. Any other data stored in Zookeeper by other applications will remain intact.                                                                                                                                         *WARNING:* This command is extremely dangerous and should not be used while Stardog cluster is running or it might cause unpredictable problems. This command is intended to be used when a new Stardog cluster is being deployed but the Zookeeper stores Stardog state from a previous deployment. After this command is executed, the first Stardog node that starts will recreate the Zookeeper data using its local state. ", examples={"* Connects to a Zookeeper at the given address and clears all the data:", "    $ stardog-admin zk clear 127.0.0.1:2180", "", "* Connects to a Zookeeper at the given address with the given authentication string and prints the data:", "    $ stardog-admin zk clear --zkauth my_secret_key 127.0.0.1:2180", "", "* Read the Zookeeper address and the authentication string from stardog.properties in the specified home directory:", "    $ stardog-admin zk clear --home stardog_home_path", "", "* Read the Zookeeper address and the authentication string from stardog.properties in $STARDOG_HOME:", "    $ stardog-admin zk clear", ""})
public final class ZkClear
extends ZkClientCommand {
    @Option(name={"--force"}, arity=0, description="Force flag. *WARNING* If this flag is set, all Stardog data in the Zookeeper will be deleted even if it  looks like there are active Stardog nodes in the cluster. This option is extremely dangerous and should not be used unless there is a fatal error with Zookeeper.")
    protected boolean force = false;
    @Option(name={"--path"}, title="zkPath", description="Zookeeper path to delete relative to Stardog root directory. By default the root Stardog directory is deleted along with its subdirectories.")
    protected String path = "";
    @Option(name={"--lock"}, title="lockName", description="Zookeeper lock to delete for Stardog. You must specify the lock or 'all' to delete all locks. If this option is specified only the lock will be deleted, nothing else. The type of lock to be deleted must be included as well. E.g. transaction/_c_1efc4025-749f-451b-b8cc-26a38e557689-__READ__0000000756 *WARNING* Deleting locks for a running cluster may cause failed operations and data inconsistencies.")
    protected String lockName = "";
    private PasswordReader reader;

    @Inject
    public ZkClear(PasswordReader reader) {
        this.reader = reader;
    }

    @Override
    protected void execute(CuratorFramework framework) throws Exception {
        List members = (List)framework.getChildren().forPath("/stardog/cluster/4.3/members");
        if (!members.isEmpty()) {
            String response;
            String memberStr = String.join((CharSequence)SystemUtils.LINE_SEPARATOR, Lists.transform((List)members, member -> "   " + member));
            System.out.println(ZkClear.get((String)"zk.clear.warning", (Object[])new Object[]{memberStr}));
            if (!this.force) {
                return;
            }
            System.out.println();
            String confirmation = ZkClear.get((String)"zk.clear.confirmation", (Object[])new Object[0]);
            while (!(response = this.reader.readLine("%s ", new Object[]{confirmation}).toLowerCase()).equals("y") && !response.equals("yes")) {
                if (response.equals("n") || response.equals("no") || response.equals("")) {
                    System.out.println(ZkClear.get((String)"zk.clear.cancel", (Object[])new Object[0]));
                    return;
                }
                System.out.println(ZkClear.get((String)"zk.clear.invalid.response", (Object[])new Object[0]));
            }
        }
        if (this.lockName.isEmpty()) {
            this.wipeZK(framework);
        } else {
            this.deleteLock(framework);
        }
    }

    private void deleteLock(CuratorFramework framework) throws Exception {
        try {
            if (this.lockName.equalsIgnoreCase("all")) {
                framework.delete().deletingChildrenIfNeeded().forPath("/stardog/cluster/4.3/locks");
            } else {
                framework.delete().deletingChildrenIfNeeded().forPath("/stardog/cluster/4.3/locks/" + this.lockName);
            }
        }
        catch (Exception e) {
            throw new CliException(ZkClear.get((String)"zk.clear.lock.fail", (Object[])new Object[0]) + e.getMessage());
        }
        System.out.println(ZkClear.get((String)"zk.clear.lock.success", (Object[])new Object[0]));
    }

    private void wipeZK(CuratorFramework framework) throws Exception {
        try {
            framework.delete().deletingChildrenIfNeeded().forPath("/stardog/cluster/4.3" + this.path);
            System.out.println(ZkClear.get((String)"zk.clear.success", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new CliException(ZkClear.get((String)"zk.clear.fail", (Object[])new Object[0]) + e.getMessage());
        }
    }
}

