/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.brsanthu.dataexporter.model.Column;
import com.complexible.common.dataexporter.Columns;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterAdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterNodeStatus;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.ServerStatus;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Command(name="status", description="Prints status information for each node in the cluster")
public final class ClusterStatus
extends SecureStardogAdminCommand<Integer> {
    @Inject
    public ClusterStatus(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        ClusterAdminConnection aPackAdminConnection = (ClusterAdminConnection)theConn.as(ClusterAdminConnection.class);
        List aNodeList = aPackAdminConnection.currentPackStatus();
        if (aNodeList.isEmpty()) {
            System.out.println("No nodes in the cluster");
        } else {
            ClusterNodeStatus aCoordNode = (ClusterNodeStatus)aNodeList.get(0);
            System.out.printf("%-25s: %s (Coordinator)%n", "Node", aCoordNode.getNodeAddress());
            System.out.printf("%-25s: %s%n", "Type", aCoordNode.getNodeType());
            System.out.printf("%-25s: %s%n", "Read Only Cluster", aCoordNode.getReadOnly());
            System.out.printf("%-25s: %s%n", "Last Admin TX ID", aCoordNode.getLastAdminTx());
            System.out.printf("%-25s: %s%n", "Last System TX ID in ZK", aCoordNode.getLastZKSystemDbTx());
            ServerStatus.printStatus((Map)aCoordNode.getMetadata());
            this.printDbTransactionMismatches(this.printDbTransactionIds(aCoordNode.getDatabaseTxns(), aCoordNode.getZKDatabaseTxns()));
            int aNodeCount = aNodeList.size() - 1;
            if (aNodeCount == 0) {
                System.out.println("No other nodes in the cluster");
            } else {
                for (ClusterNodeStatus aNode : aNodeList.subList(1, aNodeList.size())) {
                    System.out.println();
                    System.out.printf("%-25s: %s%n", "Node", aNode.getNodeAddress());
                    System.out.printf("%-25s: %s%n", "Type", aNode.getNodeType());
                    System.out.printf("%-25s: %s%n", "Read Only Cluster", aNode.getReadOnly());
                    System.out.printf("%-25s: %s%n", "Last Admin TX ID", aNode.getLastAdminTx());
                    ServerStatus.printStatus((Map)aNode.getMetadata());
                    this.printDbTransactionMismatches(this.printDbTransactionIds(aNode.getDatabaseTxns(), aNode.getZKDatabaseTxns()));
                }
            }
        }
    }

    private Map<String, Map<UUID, UUID>> printDbTransactionIds(Map<String, UUID> theDatabaseTxns, Map<String, UUID> theZKDatabaseTxns) {
        HashMap<String, Map<UUID, UUID>> mismatches = new HashMap<String, Map<UUID, UUID>>();
        System.out.printf("%-25s:%n", "Last Transaction IDs");
        List<Column> aColumns = Arrays.asList(Columns.string((String)"Database"), Columns.string((String)"Local Last Txn ID"), Columns.string((String)"ZooKeeper Last Txn ID"));
        TextTabularOutput table = new TextTabularOutput((OutputStream)System.out, aColumns);
        for (String aDb : theDatabaseTxns.keySet()) {
            UUID dbTxId = theDatabaseTxns.get(aDb);
            UUID zkTxId = theZKDatabaseTxns.get(aDb);
            table.addRow(new Object[]{aDb, dbTxId, zkTxId});
            if (dbTxId.equals(zkTxId)) continue;
            mismatches.put(aDb, Map.of(dbTxId, zkTxId));
        }
        table.output();
        return mismatches;
    }

    private void printDbTransactionMismatches(Map<String, Map<UUID, UUID>> mismatches) {
        if (!mismatches.isEmpty()) {
            System.out.printf("%-25s:%n", "WARNING IDs DO NOT MATCH");
            List<Column> aColumns = Arrays.asList(Columns.string((String)"Database"), Columns.string((String)"Local Last Txn ID"), Columns.string((String)"ZooKeeper Last Txn ID"));
            TextTabularOutput table = new TextTabularOutput((OutputStream)System.out, aColumns);
            for (String aDb : mismatches.keySet()) {
                Map<UUID, UUID> mismatchEntries = mismatches.get(aDb);
                for (UUID dbTxId : mismatchEntries.keySet()) {
                    table.addRow(new Object[]{aDb, dbTxId, mismatchEntries.get(dbTxId)});
                }
            }
            table.output();
        }
    }
}

