/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.brsanthu.dataexporter.model.Column;
import com.complexible.common.dataexporter.Columns;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterAdminConnection;
import com.complexible.stardog.api.admin.pack.StandbyNodeStatus;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.Map;

@Command(name="standby-status", description="Get the status of a standby node or read replica. This command can only be run against these node types.")
public class ClusterStandbyStatus
extends SecureStardogAdminCommand<Void> {
    private TextTabularOutput mTable = new TextTabularOutput((OutputStream)System.out, new Column[]{Columns.string((String)"Database Name"), Columns.string((String)"Estimated Bytes To Sync")});

    @Inject
    public ClusterStandbyStatus(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        ClusterAdminConnection aPackAdminConnection = (ClusterAdminConnection)theConn.as(ClusterAdminConnection.class);
        StandbyNodeStatus status = aPackAdminConnection.standbyStatus();
        System.out.printf("%s%n", "Standby Node Status Information:");
        System.out.printf("%-25s: %s%n", "Cluster Sync Address", status.getSyncClusterAddress());
        System.out.printf("%-25s: %s%n", "Stardog Version", status.getStardogVersion());
        System.out.printf("%-25s: %s%n", "Geo Replica", status.isGeoReplica());
        System.out.printf("%-25s: %s%n", "Read Replica", status.isReadReplica());
        System.out.printf("%-25s: %s%n", "State", status.getState());
        System.out.printf("%-25s: %s%n", "Sync Count", status.getSyncCount());
        System.out.printf("%-25s: %s%n", "Sync Interval (ms)", status.getSyncIntervalMs());
        System.out.printf("%-25s: %s%n", "Cluster Last Admin TX", status.getLastClusterAdminTx());
        System.out.printf("%-25s: %s%n", "Standby Last Admin TX", status.getLastStandbyNodeAdminTx());
        System.out.printf("%-25s: %s%n", "Total Bytes To Sync", status.getTotalBytesToSync());
        if (!status.getDbSyncBytes().isEmpty()) {
            for (Map.Entry entry : status.getDbSyncBytes().entrySet()) {
                this.mTable.addRow(new Object[]{entry.getKey(), entry.getValue()});
            }
            this.mTable.output();
        }
    }
}

