/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.common.base.Durations;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterAdminConnection;
import com.complexible.stardog.api.admin.pack.StandbyNodeState;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;

@Command(name="standby-pause", description="Pause a standby node or read replica. This command can only be run against these node types.")
public class ClusterStandbyPause
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-w", "--wait"}, description="Block until the standby node is paused.")
    public boolean mWaitForPaused = false;
    @Option(name={"-t", "--wait-time"}, description="The maximum amount of time to wait", title="wait time")
    public String mTimeout = "0";

    @Inject
    public ClusterStandbyPause(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        ClusterAdminConnection aPackAdminConnection = (ClusterAdminConnection)theConn.as(ClusterAdminConnection.class);
        aPackAdminConnection.setPause(true);
        long aStopTime = Durations.parse((String)this.mTimeout) + System.currentTimeMillis();
        while (this.mWaitForPaused) {
            StandbyNodeState aStatus = aPackAdminConnection.standbyState();
            if (aStatus == StandbyNodeState.PAUSED) {
                return;
            }
            if (aStopTime < System.currentTimeMillis()) {
                throw new StardogException("The standby server did not pause in the allotted amount of time.");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException aInEx) {
                throw new StardogException("The wait was interrupted");
            }
        }
    }
}

