/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterAdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterNodeStatus;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.ServerMetrics;
import com.complexible.stardog.metrics.MetricOptions;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.List;
import java.util.Map;

@Command(name="metrics", description="Retrieves metrics for each server in the cluster", examples={"* Display all metrics:", "$ stardog-admin cluster metrics", "", "* Display dbms.credentials.cache.size metric:", "$ stardog-admin cluster metrics dbms.credentials.cache.size", "", "* Display dbms.credentials.cache.size metric and metrics matching the pattern dbms.mem.*:", "$ stardog-admin cluster metrics dbms.credentials.cache.size \"dbms.mem.*\"", "", "* Display metrics matching dbms.mem.* and dbms.memory.*:", "$ stardog-admin cluster metrics \"dbms.mem.*\" \"dbms.memory.*\"", "", "* Get the thread dumps:", "$ stardog-admin cluster metrics --threads \"jvm.threads\"", ""})
public final class ClusterMetrics
extends SecureStardogAdminCommand<Integer> {
    @Option(name={"--no-databases"}, description="Do not include database-specific metrics and instead only return server-wide metrics. By defaultdatabase details will be shown.", arity=0)
    private boolean noDB = false;
    @Option(name={"--threads"}, description="Include the thread dumps from the nodes in the cluster. Thread dumps from nodes that are in the process of joining the cluster will not be included. Special nodes like standby nodes or read replicas will not return thread dumps either.", arity=0)
    private boolean threads = false;
    @Option(name={"--locks"}, description="Include locked monitors and locked synchronizers in the thread dumps. Takes effect only if --threads is provided.", arity=0)
    private boolean locks = false;
    @Option(name={"--samples"}, description="Include detailed sample information for each meter and histogram.", arity=0)
    private boolean samples = false;
    @Arguments(title={"Selected Metrics"}, description="Display only metrics, matching the specified patterns.", usage="<space-separated metric name regex patterns> (see command examples)")
    public List<String> selectedMetricPatterns;

    @Inject
    public ClusterMetrics(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        Options options = Options.create().set(MetricOptions.DATABASES, (Object)(!this.noDB ? 1 : 0)).set(MetricOptions.THREADS, (Object)this.threads).set(MetricOptions.LOCKS, (Object)this.locks).set(MetricOptions.SAMPLES, (Object)this.samples);
        ClusterAdminConnection aPackAdminConnection = (ClusterAdminConnection)theConn.as(ClusterAdminConnection.class);
        List aNodeList = aPackAdminConnection.currentPackStatus(options);
        if (aNodeList.isEmpty()) {
            System.out.println("No nodes in the cluster");
        } else {
            ClusterNodeStatus aCoordNode = (ClusterNodeStatus)aNodeList.get(0);
            System.out.printf("%-25s: %s (Coordinator)%n", "Node", aCoordNode.getNodeAddress());
            ServerMetrics.printMetrics((Map)aCoordNode.getMetadata(), this.selectedMetricPatterns);
            int aNodeCount = aNodeList.size() - 1;
            if (aNodeCount == 0) {
                System.out.println("No other nodes in the cluster");
            } else {
                for (ClusterNodeStatus aNode : aNodeList.subList(1, aNodeList.size())) {
                    System.out.println();
                    System.out.printf("%-25s: %s%n", "Node", aNode.getNodeAddress());
                    ServerMetrics.printMetrics((Map)aNode.getMetadata(), this.selectedMetricPatterns);
                }
            }
        }
    }
}

