/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.util.List;

@Command(name="info", description="Prints info about the nodes in the Stardog Pack cluster.")
public final class ClusterInfo
extends SecureStardogAdminCommand<Void> {
    @Inject
    public ClusterInfo(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws StardogException {
        ClusterAdminConnection aPackAdminConnection = (ClusterAdminConnection)theConn.as(ClusterAdminConnection.class);
        List aList = aPackAdminConnection.getNodes();
        if (aList.isEmpty()) {
            System.out.println("No nodes in the cluster");
        } else {
            System.out.println("Coordinator:");
            System.out.println("   " + (String)aList.get(0));
            int aNodeCount = aList.size() - 1;
            if (aNodeCount == 0) {
                System.out.println("No other nodes in the cluster");
            } else {
                System.out.println("Nodes:");
                for (String aNode : aList.subList(1, aList.size())) {
                    System.out.println("   " + aNode);
                }
            }
        }
    }
}

