/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.pack.cli;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.pack.ClusterAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureDiagnosticAdminCommand;
import com.complexible.stardog.util.report.DiagnosticsReport;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Command(name="diagnostics-report", description="Generate cluster diagnostic report zip")
public class ClusterDiagnosticsReport
extends SecureDiagnosticAdminCommand<Void> {
    @Option(name={"-o", "--output"}, title="The file location where the zip file containing the report will be written.", description="The path to the report output file. By default, the command will create a file called stardog-report_YYYY-MM-DD_hh-mm-ss.zip in your current directory. When using this parameter, you must specify a full file path.")
    public String mName;
    @Option(name={"-i", "--include"}, title="Additional files to include in the report.", description="This option allows you to include a list of additional specific files. By default, the command includes any .log files in $STARDOG_HOME, including stardog.log, zookeeper.log and starrocks.log, as well as audit.log and access.log if have them. It will also include stardog.properties. In some cases the default set (which can be seen with the --dry-run option) will not include all the needed information for a specific system. If you know of something relevant within $STARDOG_HOME that should be included in the zip file, this option can be used to include it. This option can be specified multiple times.")
    public List<String> mIncludes;
    @Option(name={"-x", "--exclude"}, title="Specific files to exclude from the report.", description="This option allows you to black list files from the report.  It can be handy if you have secrets in your stardog.properties file. It can be specified multiple times.")
    public List<String> mExcludes;
    @Option(name={"-s", "--no-system"}, title="Do not include system data.", description="This switch prevents system data like /var/log/kern.log from being included in the report. For a complete list of what is included in the report file use the --dry-run option.")
    public boolean mNoSystem = false;

    @Inject
    public ClusterDiagnosticsReport(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        Path aTestFile;
        ClusterAdminConnection aPackAdminConnection = (ClusterAdminConnection)theConn.as(ClusterAdminConnection.class);
        DiagnosticsReport aDiagnosticsReport = new DiagnosticsReport(this.mIncludes, this.mExcludes, false, this.mNoSystem, false);
        File aFile = aPackAdminConnection.generateClusterDiagnosticReport(aDiagnosticsReport);
        if (this.mName == null) {
            SimpleDateFormat aSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            this.mName = "stardog-report_" + aSimpleDateFormat.format(new Date()) + ".zip";
        }
        if (Files.exists(aTestFile = Paths.get(this.mName, new String[0]), new LinkOption[0])) {
            Files.move(aTestFile, Paths.get(this.mName + ".old", new String[0]), new CopyOption[0]);
        }
        Files.move(aFile.toPath(), aTestFile, new CopyOption[0]);
        System.out.println("Created the file: " + this.mName);
    }
}

