/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.license;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class VersionValidator {
    private static final int ANY = -1;
    private static final int NONE = -2;
    private static final String ANY_CHAR = "*";
    private static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("^(\\d+)(\\.\\d+){0,3}(-([\\-A-Za-z0-9]+))?(\\+([\\-A-Za-z0-9\\.]+))?$");
    private static final Pattern VERSION_EXPR_PATTERN = Pattern.compile("^(?:(\\d+)\\.){0,3}(\\*|\\d+)$");
    private final int[] mVersionExpression;

    private VersionValidator(int[] theVersionExpression) {
        Preconditions.checkArgument((theVersionExpression.length == 4 ? 1 : 0) != 0, (Object)"Version number pattern should be four identifiers long");
        this.mVersionExpression = theVersionExpression;
    }

    public static boolean isValidVersionNumber(String theVersion) {
        return VERSION_NUMBER_PATTERN.matcher(theVersion).find();
    }

    public static boolean isValidVersionExpression(String theExpression) {
        String aVersion = VersionValidator.cleanVersion(theExpression);
        return VERSION_EXPR_PATTERN.matcher(aVersion).find();
    }

    public static String cleanVersion(String theExpression) {
        String aVersion = theExpression;
        if (aVersion.contains("+")) {
            aVersion = aVersion.substring(0, aVersion.indexOf("+"));
        }
        if (aVersion.contains("-")) {
            aVersion = aVersion.substring(0, aVersion.indexOf("-"));
        }
        return aVersion;
    }

    public boolean isValid(String theVersion) {
        if (VersionValidator.isValidVersionNumber(theVersion)) {
            int aIndex = 0;
            String aVersion = VersionValidator.cleanVersion(theVersion);
            for (String aNum : Splitter.on((String)".").trimResults().omitEmptyStrings().split((CharSequence)aVersion)) {
                try {
                    int aInt = Integer.parseInt(aNum);
                    if (this.mVersionExpression[aIndex] == -1) {
                        return true;
                    }
                    if (this.mVersionExpression[aIndex] < aInt) {
                        return false;
                    }
                    if (this.mVersionExpression[aIndex] > aInt) {
                        return true;
                    }
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                ++aIndex;
            }
            return true;
        }
        return false;
    }

    public static VersionValidator forExpression(String theExpression) throws Exception {
        if (theExpression == null) {
            return VersionValidator.build().any();
        }
        if (!VersionValidator.isValidVersionExpression(theExpression)) {
            throw new Exception("Invalid Version Pattern");
        }
        int[] aExpr = new int[4];
        Arrays.fill(aExpr, -2);
        int aIndex = 0;
        for (String aNum : Splitter.on((String)".").trimResults().omitEmptyStrings().split((CharSequence)theExpression)) {
            try {
                if (aNum.equals(ANY_CHAR)) {
                    for (int i = aIndex; i < aExpr.length; ++i) {
                        aExpr[i] = -1;
                    }
                    break;
                }
                int aInt = Integer.parseInt(aNum);
                Preconditions.checkArgument((aInt >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative version numbers.");
                aExpr[aIndex] = aInt;
            }
            catch (NumberFormatException ex) {
                throw new Exception(ex);
            }
            ++aIndex;
        }
        return new VersionValidator(aExpr);
    }

    public static MajorValidator build() {
        return new MajorValidatorImpl();
    }

    private static class PointValidatorImpl
    implements PointValidator {
        private final int[] mExpr;

        private PointValidatorImpl(int[] theExpr) {
            this.mExpr = theExpr;
        }

        @Override
        public VersionValidator anyPoint() {
            return new VersionValidator(this.mExpr);
        }

        @Override
        public VersionValidator point(int theVersion) {
            Preconditions.checkArgument((theVersion >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative version numbers.");
            this.mExpr[3] = theVersion;
            return new VersionValidator(this.mExpr);
        }
    }

    private static class MicroValidatorImpl
    implements MicroValidator {
        private final int[] mExpr;

        private MicroValidatorImpl(int[] theExpr) {
            this.mExpr = theExpr;
        }

        @Override
        public VersionValidator anyMicro() {
            return new VersionValidator(this.mExpr);
        }

        @Override
        public PointValidator micro(int theVersion) {
            Preconditions.checkArgument((theVersion >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative version numbers.");
            this.mExpr[2] = theVersion;
            return new PointValidatorImpl(this.mExpr);
        }
    }

    private static class MinorValidatorImpl
    implements MinorValidator {
        private final int[] mExpr;

        private MinorValidatorImpl(int[] theExpr) {
            this.mExpr = theExpr;
        }

        @Override
        public VersionValidator anyMinor() {
            return new VersionValidator(this.mExpr);
        }

        @Override
        public MicroValidator minor(int theVersion) {
            Preconditions.checkArgument((theVersion >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative version numbers.");
            this.mExpr[1] = theVersion;
            return new MicroValidatorImpl(this.mExpr);
        }
    }

    private static class MajorValidatorImpl
    implements MajorValidator {
        private final int[] aExpr = new int[4];

        private MajorValidatorImpl() {
            Arrays.fill(this.aExpr, -1);
        }

        @Override
        public VersionValidator any() {
            return new VersionValidator(this.aExpr);
        }

        @Override
        public MinorValidator major(int theVersion) {
            Preconditions.checkArgument((theVersion >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative version numbers.");
            this.aExpr[0] = theVersion;
            return new MinorValidatorImpl(this.aExpr);
        }
    }

    public static interface PointValidator {
        public VersionValidator anyPoint();

        public VersionValidator point(int var1);
    }

    public static interface MicroValidator {
        public VersionValidator anyMicro();

        public PointValidator micro(int var1);
    }

    public static interface MinorValidator {
        public VersionValidator anyMinor();

        public MicroValidator minor(int var1);
    }

    public static interface MajorValidator {
        public VersionValidator any();

        public MinorValidator major(int var1);
    }
}

