/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.license;

import com.clarkparsia.license.CompanyImpl;
import com.clarkparsia.license.License;
import com.clarkparsia.license.LicenseConstants;
import com.clarkparsia.license.LicenseType;
import com.clarkparsia.license.LicenseVariant;
import com.clarkparsia.license.Person;
import com.clarkparsia.license.PersonImpl;
import com.google.common.collect.ImmutableMap;
import de.schlichtherle.license.LicenseContent;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

final class LicenseContentLicense
implements License,
LicenseConstants {
    private final LicenseContent mLicenseContent;

    LicenseContentLicense(LicenseContent theLicenseContent) {
        this.mLicenseContent = theLicenseContent;
    }

    public ImmutableMap<String, String> getData() {
        return ImmutableMap.copyOf((Map)((Map)this.mLicenseContent.getExtra()));
    }

    @Override
    public boolean isFloating() {
        return this.getData().containsKey((Object)"floating") && Boolean.parseBoolean((String)this.getData().get((Object)"floating"));
    }

    @Override
    public Person getLicensee() {
        return new PersonImpl((String)this.getData().get((Object)"name"), (String)this.getData().get((Object)"email"), new CompanyImpl((String)this.getData().get((Object)"company")));
    }

    @Override
    public String getNote() {
        return (String)this.getData().get((Object)"note");
    }

    @Override
    public String getVersionIssued() {
        return (String)this.getData().get((Object)"version_issued");
    }

    @Override
    public LicenseVariant getVariant() {
        return LicenseVariant.valueOf(this.mLicenseContent.getConsumerType());
    }

    @Override
    public LicenseType getType() {
        String aName = (String)this.getData().get((Object)"type");
        if (aName == null) {
            return this.isDownload() ? LicenseType.Trial : (this.getExpirationDate() != null ? LicenseType.Subscription : LicenseType.Perpetual);
        }
        return LicenseType.valueOf(aName);
    }

    @Override
    public boolean isDownload() {
        return this.getData().containsKey((Object)"download") && Boolean.parseBoolean((String)this.getData().get((Object)"download"));
    }

    @Override
    public Date getExpirationDate() {
        if (this.mLicenseContent.getNotAfter() == null) {
            return null;
        }
        return this.mLicenseContent.getNotAfter();
    }

    @Override
    public Date getSupportEndDate() {
        if (this.getData().containsKey((Object)"maintenance")) {
            return new Date(Long.parseLong((String)this.getData().get((Object)"maintenance")));
        }
        return null;
    }

    @Override
    public String getProduct() {
        return (String)this.getData().get((Object)"product_id");
    }

    @Override
    public String getVersion() {
        return (String)this.getData().get((Object)"product_version");
    }

    @Override
    public int getQuantity() {
        return this.mLicenseContent.getConsumerAmount();
    }

    @Override
    public Date getIssueDate() {
        return this.mLicenseContent.getIssued();
    }

    @Override
    public UUID getUUID() {
        return UUID.fromString((String)this.getData().get((Object)"license_id"));
    }
}

