/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.license;

import com.clarkparsia.license.CompanyImpl;
import com.clarkparsia.license.License;
import com.clarkparsia.license.LicenseType;
import com.clarkparsia.license.LicenseVariant;
import com.clarkparsia.license.Person;
import com.clarkparsia.license.PersonImpl;
import com.clarkparsia.license.VersionValidator;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class DefaultLicense
implements License {
    private final Person mPerson;
    private final String mProductId;
    private final ImmutableMap<String, String> mMetadata;
    private final String mVersion;
    private final String mVersionIssued;
    private final int mQuantity;
    private final LicenseType mType;
    private final LicenseVariant mVariant;
    private final String mNote;
    private final Date mIssueDate;
    private final Date mExpirationDate;
    private final Date mSupportEndDate;
    private final UUID mId;
    private final boolean mFloating;
    private final boolean mDownload;

    public DefaultLicense(Person thePerson, UUID theId, String theProductId, String theVersion, String theVersionIssued, LicenseVariant theVariant, LicenseType theType, int theQuantity, Date theIssueDate, Date theExpirationDate, Date theSupportEndDate, boolean theDownload, boolean theFloating, String theNote, Map<String, String> theMetadata) {
        Preconditions.checkArgument((thePerson != null ? 1 : 0) != 0, (Object)"You must supply an email address for the licensee");
        Preconditions.checkArgument((theProductId != null ? 1 : 0) != 0, (Object)"You must supply a product to be licensed.");
        this.mDownload = theDownload;
        this.mFloating = theFloating;
        this.mIssueDate = theIssueDate;
        this.mSupportEndDate = theSupportEndDate;
        this.mExpirationDate = theExpirationDate;
        this.mPerson = thePerson;
        this.mProductId = theProductId;
        this.mMetadata = ImmutableMap.copyOf(theMetadata);
        this.mVersion = theVersion;
        this.mVersionIssued = theVersionIssued;
        this.mQuantity = theQuantity;
        this.mType = theType;
        this.mVariant = theVariant;
        this.mNote = theNote;
        this.mId = theId;
    }

    @Override
    public String getNote() {
        return this.mNote;
    }

    @Override
    public boolean isDownload() {
        return this.mDownload;
    }

    @Override
    public boolean isFloating() {
        return this.mFloating;
    }

    @Override
    public UUID getUUID() {
        return this.mId;
    }

    public ImmutableMap<String, String> getData() {
        return this.mMetadata;
    }

    @Override
    public Date getExpirationDate() {
        return this.mExpirationDate;
    }

    @Override
    public Date getIssueDate() {
        return this.mIssueDate;
    }

    @Override
    public Date getSupportEndDate() {
        return this.mSupportEndDate;
    }

    @Override
    public Person getLicensee() {
        return this.mPerson;
    }

    @Override
    public String getProduct() {
        return this.mProductId;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public String getVersionIssued() {
        return this.mVersionIssued;
    }

    @Override
    public int getQuantity() {
        return this.mQuantity;
    }

    @Override
    public LicenseType getType() {
        return this.mType;
    }

    @Override
    public LicenseVariant getVariant() {
        return this.mVariant;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mVersion, this.mIssueDate, this.mExpirationDate, this.mSupportEndDate, this.mProductId, this.mMetadata, this.mVariant, this.mType, this.mPerson, this.mQuantity, this.mFloating, this.mVersionIssued, this.mNote, this.mDownload});
    }

    public boolean equals(Object theObj) {
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof DefaultLicense) {
            DefaultLicense aLicense = (DefaultLicense)theObj;
            return Objects.equal((Object)this.mVersion, (Object)aLicense.mVersion) && Objects.equal((Object)this.mIssueDate, (Object)aLicense.mIssueDate) && Objects.equal((Object)this.mExpirationDate, (Object)aLicense.mExpirationDate) && Objects.equal((Object)this.mSupportEndDate, (Object)aLicense.mSupportEndDate) && Objects.equal((Object)this.mProductId, (Object)aLicense.mProductId) && Objects.equal(this.mMetadata, aLicense.mMetadata) && Objects.equal((Object)((Object)this.mVariant), (Object)((Object)aLicense.mVariant)) && Objects.equal((Object)((Object)this.mType), (Object)((Object)aLicense.mType)) && Objects.equal((Object)this.mPerson, (Object)aLicense.mPerson) && Objects.equal((Object)this.mId, (Object)aLicense.mId) && Objects.equal((Object)this.mFloating, (Object)aLicense.mFloating) && Objects.equal((Object)this.mDownload, (Object)aLicense.mDownload) && Objects.equal((Object)this.mVersionIssued, (Object)aLicense.mVersionIssued) && Objects.equal((Object)this.mNote, (Object)aLicense.mNote) && Objects.equal((Object)this.mQuantity, (Object)aLicense.mQuantity);
        }
        return false;
    }

    public static Builder to(Person theLicensee) {
        return new Builder(theLicensee);
    }

    public static Builder to(String theName, String theEmail, String theCompany) {
        return DefaultLicense.to(new PersonImpl(theName, theEmail, theCompany == null ? null : new CompanyImpl(theCompany)));
    }

    public static final class Builder {
        public static final long NO_DURATION = Long.MIN_VALUE;
        public static final long NO_MAINTENANCE = Long.MIN_VALUE;
        private String mVersionIssued;
        private Date mExpirationDate = null;
        private String mProductId;
        private Map<String, String> mMetadata = Maps.newHashMap();
        private String mVersion;
        private int mQuantity = 1;
        private LicenseType mType;
        private LicenseVariant mVariant = LicenseVariant.Community;
        private Date mSupportEndDate = null;
        private Date mIssueDate;
        private Person mPerson;
        private UUID mId;
        private boolean mFloating;
        private boolean mDownload;
        private String mNote;

        public Builder(Person thePerson) {
            this.mPerson = thePerson;
        }

        public Builder note(String theNote) {
            this.mNote = theNote;
            return this;
        }

        public Builder download(boolean theDownload) {
            this.mDownload = theDownload;
            return this;
        }

        public Builder floating(boolean theFloating) {
            this.mFloating = theFloating;
            return this;
        }

        public Builder uuid(UUID theId) {
            this.mId = theId;
            return this;
        }

        public Builder issued(Date theDate) {
            this.mIssueDate = theDate;
            return this;
        }

        public Builder versionIssued(String theVersion) {
            this.mVersionIssued = theVersion;
            return this;
        }

        public Builder variant(LicenseVariant theVariant) {
            this.mVariant = theVariant;
            return this;
        }

        public Builder expiresIn(long theDuration, TimeUnit theUnit) {
            this.mExpirationDate = theDuration == Long.MIN_VALUE ? null : new Date(System.currentTimeMillis() + theUnit.toMillis(theDuration));
            return this;
        }

        public Builder expiresOn(Date theDate) {
            this.mExpirationDate = theDate;
            return this;
        }

        public Builder product(String theProduct) {
            this.mProductId = theProduct;
            return this;
        }

        public Builder version(String theVersion) {
            String aVersion = VersionValidator.cleanVersion(theVersion);
            Preconditions.checkArgument((boolean)VersionValidator.isValidVersionExpression(aVersion), (String)"%s is not a valid version number.", (Object)aVersion);
            this.mVersion = aVersion;
            return this;
        }

        public Builder metadata(Map<String, String> theMeta) {
            this.mMetadata = theMeta;
            return this;
        }

        public Builder addMetadata(String theKey, String theValue) {
            this.mMetadata.put(theKey, theValue);
            return this;
        }

        public Builder quantity(int theQuantity) {
            this.mQuantity = theQuantity;
            return this;
        }

        public Builder type(LicenseType theType) {
            this.mType = theType;
            return this;
        }

        public Builder supportFor(long theDuration, TimeUnit theUnit) {
            this.mSupportEndDate = theDuration == Long.MIN_VALUE ? null : new Date(System.currentTimeMillis() + theUnit.toMillis(theDuration));
            return this;
        }

        public Builder supportUntil(Date theDate) {
            this.mSupportEndDate = theDate;
            return this;
        }

        public DefaultLicense build() {
            Preconditions.checkArgument((this.mPerson != null ? 1 : 0) != 0, (Object)"You must supply an email address for the licensee");
            Preconditions.checkArgument((this.mProductId != null ? 1 : 0) != 0, (Object)"You must supply a product to be licensed.");
            Preconditions.checkArgument((this.mVersion != null ? 1 : 0) != 0, (Object)"Version must be specified.");
            if (this.mVersionIssued == null && !this.mVersion.contains("*")) {
                this.mVersionIssued = this.mVersion;
            }
            Preconditions.checkArgument((this.mVersionIssued != null ? 1 : 0) != 0, (Object)"Version issued must be specified.");
            Preconditions.checkArgument((!this.mVersionIssued.contains("*") ? 1 : 0) != 0, (Object)"Version issued cannot contain wildcard numbers.");
            if (this.mIssueDate == null) {
                this.mIssueDate = new Date();
            }
            if (this.mId == null) {
                this.mId = UUID.randomUUID();
            }
            return new DefaultLicense(this.mPerson, this.mId, this.mProductId, this.mVersion, this.mVersionIssued, this.mVariant, this.mType, this.mQuantity, this.mIssueDate, this.mExpirationDate, this.mSupportEndDate, this.mDownload, this.mFloating, this.mNote, this.mMetadata);
        }
    }
}

