/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.update.io;

import com.complexible.stardog.api.update.UpdateOperation;
import com.complexible.stardog.api.update.io.UpdateTurtleWriter;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.vocabs.RDF;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class UpdatePatchWriter
extends UpdateTurtleWriter {
    protected Statement lastStatement = Values.statement((Resource)RDF.TYPE, (IRI)RDF.TYPE, (Value)RDF.TYPE);

    public UpdatePatchWriter(OutputStream out) {
        super(out, false);
    }

    public void end() throws RDFHandlerException {
        try {
            this.mWriter.write(System.lineSeparator());
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        super.end();
    }

    public void handle(@Nonnull Statement st) throws RDFHandlerException {
        Preconditions.checkState((this.mOperation != null ? 1 : 0) != 0, (Object)"Additions or removals need to be started explicitly before handling statements");
        Resource subj = st.subject();
        IRI pred = st.predicate();
        Value obj = st.object();
        Resource context = st.context();
        try {
            this.mWriter.write(System.lineSeparator());
            this.mWriter.write(this.mOperation.getType() == UpdateOperation.Type.ADD ? "A " : "D ");
            if (Objects.equal((Object)subj, (Object)this.lastStatement.subject())) {
                this.mWriter.write("R");
            } else {
                this.writeResource(subj);
            }
            this.mWriter.write(" ");
            if (Objects.equal((Object)pred, (Object)this.lastStatement.predicate())) {
                this.mWriter.write("R");
            } else {
                this.writeIRI(pred);
            }
            this.mWriter.write(" ");
            if (Objects.equal((Object)obj, (Object)this.lastStatement.object())) {
                this.mWriter.write("R");
            } else {
                this.writeValue(obj);
            }
            this.mWriter.write(" ");
            if (!Values.isDefaultGraph((Resource)context)) {
                if (Objects.equal((Object)context, (Object)this.lastStatement.context())) {
                    this.mWriter.write("R");
                } else {
                    this.writeResource(context);
                }
                this.mWriter.write(" ");
            }
            this.mWriter.write(".");
            this.lastStatement = st;
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

