/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.update;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Adder;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.Remover;
import com.complexible.stardog.api.update.UpdateHandler;
import com.complexible.stardog.api.update.UpdateOperation;
import com.google.common.base.Preconditions;
import com.stardog.stark.Statement;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import javax.annotation.Nonnull;

public class UpdateExecutor
extends AbstractRDFHandler
implements UpdateHandler {
    private final Connection mConnection;
    private final Adder mAdder;
    private final Remover mRemover;
    protected UpdateOperation.Type mOperation = null;

    public UpdateExecutor(Connection theConnection) throws StardogException {
        this.mConnection = theConnection;
        this.mAdder = theConnection.add();
        this.mRemover = theConnection.remove();
    }

    public void start() {
        try {
            this.mConnection.begin();
        }
        catch (StardogException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void end() throws RDFHandlerException {
        try {
            this.mConnection.commit();
        }
        catch (StardogException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handle(@Nonnull Statement st) throws RDFHandlerException {
        try {
            switch (this.mOperation) {
                case ADD: {
                    this.mAdder.statement(st);
                    break;
                }
                case REMOVE: {
                    this.mRemover.statement(st);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid action type.");
                }
            }
        }
        catch (StardogException e) {
            throw new RDFHandlerException("There was a problem executing the operation", (Throwable)e);
        }
    }

    @Override
    public void startOperation(UpdateOperation theOperation) {
        Preconditions.checkState((this.mOperation == null ? 1 : 0) != 0, (String)"%s have already been started", (Object)((Object)this.mOperation));
        Preconditions.checkArgument((boolean)theOperation.getUnboundParameters().isEmpty(), (String)"Cannot execute an operation with unbound parameters %s", theOperation.getUnboundParameters());
        this.mOperation = theOperation.getType();
    }

    @Override
    public void endOperation(UpdateOperation theOperation) {
        Preconditions.checkState((this.mOperation == theOperation.getType() ? 1 : 0) != 0, (String)"%s have not been started yet", (Object)theOperation);
        this.mOperation = null;
    }
}

