/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.stardog.api.test.Test;
import com.complexible.stardog.api.test.Testable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;

public class TestSuite
implements Testable {
    private final String name;
    private Path dir;
    private Test defaults;
    final List<Testable> tests;

    public TestSuite(String name, Path dir, Test defaults) {
        this(name, dir, defaults, (List<? extends Testable>)ImmutableList.of());
    }

    public TestSuite(String name, Path dir, Test defaults, List<? extends Testable> tests) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.dir = (Path)Preconditions.checkNotNull((Object)dir);
        this.tests = Lists.newArrayList(tests);
        this.defaults = new Test(defaults);
        this.defaults().setSuite(this);
    }

    public int count() {
        MutableInt count = new MutableInt(0);
        this.test(test -> count.increment());
        return count.intValue();
    }

    @Override
    public String name() {
        return this.name;
    }

    public Path dir() {
        return this.dir;
    }

    public Test defaults() {
        return this.defaults;
    }

    public List<Testable> tests() {
        return this.tests;
    }

    @Override
    public void test(Consumer<Test> tester) {
        this.tests.forEach(test -> test.test(tester));
    }

    @Override
    public String toString(String indent) {
        return this.tests.stream().map(test -> test.toString(indent + "   ")).collect(Collectors.joining(System.lineSeparator(), indent + this.toString() + System.lineSeparator(), ""));
    }

    public String toString() {
        return "TestSuite{name='" + this.name + "', dir='" + String.valueOf(this.dir()) + "'}";
    }
}

