/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.test;

import com.complexible.stardog.Schemas;
import com.complexible.stardog.api.test.TestSuite;
import com.complexible.stardog.api.test.Testable;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;

public class Test
implements Testable {
    public static final int UNDEFINED = -1;
    private final String name;
    private TestSuite suite;
    private String server;
    private String db;
    private String queryFile;
    private String queryString;
    private String queryStored;
    private String reasoning = Schemas.NULL;
    private String resultFile;
    private int resultCount = -1;
    private boolean resultOrdered = false;
    private int warmups = 0;
    private int runs = 1;
    private long expectedTime = -1L;
    private int failureThreshold = 10;
    private boolean ignored = false;

    public Test() {
        this.name = "";
        this.suite = null;
    }

    public Test(Test that) {
        this("", that);
    }

    public Test(String name, Test that) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.suite = that.suite;
        this.server = that.server;
        this.db = that.db;
        this.resultOrdered = that.resultOrdered;
        this.reasoning = that.reasoning;
        this.warmups = that.warmups;
        this.runs = that.runs;
    }

    @Override
    public String name() {
        return this.name;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    @Override
    public void test(Consumer<Test> tester) {
        tester.accept(this);
    }

    public TestSuite suite() {
        return this.suite;
    }

    public void setSuite(TestSuite suite) {
        this.suite = suite;
    }

    public String server() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String db() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String queryFile() {
        return this.queryFile;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String queryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String queryStored() {
        return this.queryStored;
    }

    public void setQueryStored(String queryStored) {
        this.queryStored = queryStored;
    }

    public String isReasoning() {
        return this.reasoning;
    }

    public void setReasoning(String reasoning) {
        this.reasoning = reasoning;
    }

    public String resultFile() {
        return this.resultFile;
    }

    public void setResultFile(String resultFile) {
        this.resultFile = resultFile;
    }

    public int resultCount() {
        return this.resultCount;
    }

    public void setResultCount(int resultCount) {
        this.resultCount = resultCount;
    }

    public boolean isResultOrdered() {
        return this.resultOrdered;
    }

    public void setResultOrdered(boolean resultOrdered) {
        this.resultOrdered = resultOrdered;
    }

    public int warmups() {
        return this.warmups;
    }

    public void setWarmups(int warmups) {
        this.warmups = warmups;
    }

    public int runs() {
        return this.runs;
    }

    public void setRuns(int runs) {
        this.runs = runs;
    }

    public long expectedTime() {
        return this.expectedTime;
    }

    public void setExpectedTime(long expectedTime) {
        this.expectedTime = expectedTime;
    }

    public int failureThreshold() {
        return this.failureThreshold;
    }

    public void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public String toString() {
        return "Test{name='" + this.name + "', queryFile='" + this.queryFile + "', queryString='" + this.queryString + "', queryStored='" + this.queryStored + "', db='" + this.db + "', server='" + this.server + "', reasoning='" + this.reasoning + "', resultOrdered=" + this.resultOrdered + ", resultFile='" + this.resultFile + "', resultCount=" + this.resultCount + ", warmups=" + this.warmups + ", runs=" + this.runs + ", expectedTime=" + this.expectedTime + "}";
    }

    @Override
    public String toString(String indent) {
        return indent + String.valueOf(this);
    }
}

