/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Change;
import com.complexible.common.base.ChangeList;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.stardog.CommitResult;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.api.impl.ChangeCollector;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.stardog.stark.Statement;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OrderedChangeCollector
implements ChangeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final int mBufferSize;
    private final ChangeList<ConnectionChangeType, Object> mPendingChanges = ChangeList.create();
    private Change<ConnectionChangeType, List<Statement>> mCurrPending = null;
    private long mNumPending = 0L;
    private final AbstractConnection mConnection;

    OrderedChangeCollector(AbstractConnection theConnection, int theBufferSize) {
        this.mConnection = theConnection;
        this.mBufferSize = theBufferSize;
    }

    @Override
    @VisibleForTesting
    public ChangeList<ConnectionChangeType, Object> getPendingChanges() {
        ChangeList aChangeList = ChangeList.create().appendAll(this.mPendingChanges);
        if (this.mCurrPending != null) {
            aChangeList.append(Change.of((Enum)((ConnectionChangeType)this.mCurrPending.getChangeType()), (Object)MemoryStatementSource.of((Iterable)((Iterable)this.mCurrPending.getChange()))));
        }
        return aChangeList;
    }

    @Override
    public final CommitResult pushOutstanding(boolean doCommit) throws StardogException {
        LOGGER.debug("Pushing outstanding changes to index");
        CommitResult aResult = null;
        if (this.mCurrPending != null) {
            this.mPendingChanges.append(Change.of((Enum)((ConnectionChangeType)this.mCurrPending.getChangeType()), (Object)MemoryStatementSource.of((Iterable)((Iterable)this.mCurrPending.getChange()))));
        }
        if (!this.mPendingChanges.isEmpty()) {
            try {
                aResult = this.mConnection.applyChanges(this.mPendingChanges, doCommit);
            }
            finally {
                this.cleanupPendingChanges(false);
            }
        } else if (doCommit) {
            aResult = this.mConnection._commit();
        }
        LOGGER.debug("Index sync complete");
        return aResult;
    }

    @Override
    public void cleanupPendingChanges(boolean theClosePending) {
        if (theClosePending) {
            AutoCloser.close(this.mPendingChanges);
        }
        this.mPendingChanges.clear();
        this.mNumPending = 0L;
        this.mCurrPending = null;
    }

    @Override
    public final void pushOutstandingIfNecessary() throws StardogException {
        if (this.mNumPending > (long)this.mBufferSize || this.mPendingChanges.size() > this.mBufferSize) {
            this.pushOutstanding(false);
        }
    }

    @Override
    public void apply(ConnectionChangeType theChangeType, Statement theChange) throws StardogException {
        if (this.mCurrPending == null) {
            this.mCurrPending = Change.of((Enum)theChangeType, (Object)Lists.newArrayList((Object[])new Statement[]{theChange}));
        } else if (ConnectionChangeType.canMerge((ConnectionChangeType)this.mCurrPending.getChangeType(), theChangeType)) {
            ((List)this.mCurrPending.getChange()).add(theChange);
        } else {
            this.mPendingChanges.append(Change.of((Enum)((ConnectionChangeType)this.mCurrPending.getChangeType()), (Object)MemoryStatementSource.of((Iterable)((Iterable)this.mCurrPending.getChange()))));
            this.mCurrPending = Change.of((Enum)theChangeType, (Object)Lists.newArrayList((Object[])new Statement[]{theChange}));
        }
        ++this.mNumPending;
        this.pushOutstandingIfNecessary();
    }

    @Override
    public void apply(ConnectionChangeType theChangeType, Collection<Statement> theChange) throws StardogException {
        long aSize = theChange.size();
        if (aSize > (long)this.mBufferSize) {
            if (this.mCurrPending != null) {
                this.mPendingChanges.append(Change.of((Enum)((ConnectionChangeType)this.mCurrPending.getChangeType()), (Object)MemoryStatementSource.of((Iterable)((Iterable)this.mCurrPending.getChange()))));
                this.mCurrPending = null;
            }
            this.mPendingChanges.append(Change.of((Enum)theChangeType, (Object)MemoryStatementSource.of(theChange)));
        } else if (this.mCurrPending == null) {
            this.mCurrPending = Change.of((Enum)theChangeType, (Object)Lists.newArrayList(theChange));
        } else if (ConnectionChangeType.canMerge((ConnectionChangeType)this.mCurrPending.getChangeType(), theChangeType)) {
            ((List)this.mCurrPending.getChange()).addAll(theChange);
        } else {
            this.mPendingChanges.append(Change.of((Enum)((ConnectionChangeType)this.mCurrPending.getChangeType()), (Object)MemoryStatementSource.of((Iterable)((Iterable)this.mCurrPending.getChange()))));
            this.mCurrPending = Change.of((Enum)theChangeType, (Object)Lists.newArrayList(theChange));
        }
        this.mNumPending += (long)theChange.size();
        this.pushOutstandingIfNecessary();
    }

    @Override
    public void apply(Change<ConnectionChangeType, Object> theChange) throws StardogException {
        if (this.mCurrPending != null && !ConnectionChangeType.canMerge((ConnectionChangeType)this.mCurrPending.getChangeType(), (ConnectionChangeType)theChange.getChangeType())) {
            this.mPendingChanges.append(Change.of((Enum)((ConnectionChangeType)this.mCurrPending.getChangeType()), (Object)MemoryStatementSource.of((Iterable)((Iterable)this.mCurrPending.getChange()))));
            this.mCurrPending = null;
        }
        this.mPendingChanges.append(theChange);
        this.pushOutstandingIfNecessary();
    }
}

