/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.Dates;
import com.complexible.common.rdf.query.SPARQLUtil;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.api.Query;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stardog.stark.Datatype;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.Dataset;
import com.stardog.stark.query.Datasets;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractQuery<T>
implements Query<T> {
    private String mID = "";
    protected final String mQuery;
    private final String mBaseURI;
    protected final Map<String, Value> mBindings = Maps.newHashMap();
    protected final Map<String, String> mHints = Maps.newHashMap();
    protected Dataset mDataset = Datasets.NO_DATASET;
    protected String mSchema = null;

    protected AbstractQuery(String theQueryStr, String theBaseURI) {
        this.mQuery = theQueryStr;
        this.mBaseURI = theBaseURI;
    }

    @Override
    public Query<T> id(String theID) {
        this.mID = theID;
        return this;
    }

    @Override
    public String getID() {
        return this.mID;
    }

    @Override
    public String toString() {
        return SPARQLUtil.toQuery((String)this.mQuery, (String)this.mSchema, (long)-1L, (long)-1L, this.mBindings, (Dataset)this.dataset());
    }

    @Override
    public String queryString() {
        return this.mQuery;
    }

    @Override
    public String baseURI() {
        return this.mBaseURI;
    }

    @Override
    public Map<String, Value> parameters() {
        return this.mBindings;
    }

    @Override
    public Dataset dataset() {
        return this.mDataset;
    }

    @Override
    public Query<T> dataset(Dataset theDataset) {
        this.mDataset = (Dataset)Preconditions.checkNotNull((Object)theDataset, (Object)"Dataset cannot be null, use Datasets#NO_DATASET to reset this property.");
        return this;
    }

    @Override
    public boolean isReasoningEnabled() {
        return this.mSchema != null;
    }

    @Override
    public Query<T> reasoning(boolean theReasoningFlag) {
        this.mSchema = theReasoningFlag ? (String)MoreObjects.firstNonNull((Object)this.mSchema, (Object)"default") : Schemas.NULL;
        return this;
    }

    @Override
    public Query<T> schema(String theSchema) {
        this.mSchema = theSchema;
        return this;
    }

    @Override
    public String getSchema() {
        return this.mSchema;
    }

    @Override
    public Query<T> parameter(String theName, Object theObj) {
        if (theObj == null) {
            this.mBindings.remove(theName);
            return this;
        }
        if (theObj instanceof Value) {
            return this.parameter(theName, (Value)theObj);
        }
        if (theObj instanceof Boolean) {
            return this.parameter(theName, (Boolean)theObj);
        }
        if (theObj instanceof Long) {
            return this.parameter(theName, (Long)theObj);
        }
        if (theObj instanceof Integer) {
            return this.parameter(theName, (Value)Values.literal((Number)((Integer)theObj)));
        }
        if (theObj instanceof Float) {
            return this.parameter(theName, ((Float)theObj).floatValue());
        }
        if (theObj instanceof Double) {
            return this.parameter(theName, (Double)theObj);
        }
        if (theObj instanceof Short) {
            return this.parameter(theName, (Short)theObj);
        }
        if (theObj instanceof Date) {
            return this.parameter(theName, (Date)theObj);
        }
        if (theObj instanceof Byte) {
            return this.parameter(theName, (Byte)theObj);
        }
        if (theObj instanceof GregorianCalendar) {
            return this.parameter(theName, (GregorianCalendar)theObj);
        }
        if (theObj instanceof URI) {
            return this.parameter(theName, (URI)theObj);
        }
        if (theObj instanceof String) {
            return this.parameter(theName, (String)theObj);
        }
        return this;
    }

    @Override
    public Query<T> parameter(String theName, Value theValue) {
        if (theValue == null) {
            this.mBindings.remove(theName);
        } else {
            this.mBindings.put(theName, theValue);
        }
        return this;
    }

    @Override
    @Nonnull
    public Query<T> hint(@Nonnull String theName, String theValue) {
        if (theValue == null) {
            this.mHints.remove(theName);
        } else {
            this.mHints.put(theName, theValue);
        }
        return this;
    }

    @Override
    public Map<String, String> hints() {
        return ImmutableMap.copyOf(this.mHints);
    }

    @Override
    public Query<T> parameter(String theName, int theValue) {
        return this.parameter(theName, (Value)Values.literal((int)theValue));
    }

    @Override
    public Query<T> parameter(String theName, long theValue) {
        return this.parameter(theName, (Value)Values.literal((long)theValue));
    }

    @Override
    public Query<T> parameter(String theName, float theValue) {
        return this.parameter(theName, (Value)Values.literal((float)theValue));
    }

    @Override
    public Query<T> parameter(String theName, double theValue) {
        return this.parameter(theName, (Value)Values.literal((double)theValue));
    }

    @Override
    public Query<T> parameter(String theName, short theValue) {
        return this.parameter(theName, (Value)Values.literal((short)theValue));
    }

    @Override
    public Query<T> parameter(String theName, boolean theValue) {
        return this.parameter(theName, (Value)Values.literal((boolean)theValue));
    }

    @Override
    public Query<T> parameter(String theName, byte theValue) {
        return this.parameter(theName, (Value)Values.literal((byte)theValue));
    }

    @Override
    public Query<T> parameter(String theName, String theValue) {
        return this.parameter(theName, (Value)Values.literal((String)theValue, (Datatype)Datatype.STRING));
    }

    @Override
    public Query<T> parameter(String theName, Date theValue) {
        return this.parameter(theName, (Value)Values.literal((String)Dates.date((Date)theValue), (Datatype)Datatype.DATE));
    }

    @Override
    public Query<T> parameter(String theName, GregorianCalendar theValue) {
        return this.parameter(theName, (Value)Values.literal((GregorianCalendar)theValue));
    }

    @Override
    public Query<T> parameter(String theName, URI theURI) {
        return this.parameter(theName, (Value)Values.literal((String)theURI.toString(), (Datatype)Datatype.ANYURI));
    }
}

