/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.admin;

import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.SensitivePropertyManager;
import com.complexible.stardog.security.SecurityOptions;
import com.complexible.stardog.security.SensitiveProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.stardog.stark.IRI;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultSensitivePropertyManager
implements SensitivePropertyManager {
    private final AdminConnection mAdminConnection;
    private final String mDb;
    private final SetMultimap<String, IRI> mProperties;

    public DefaultSensitivePropertyManager(Connection theConnection) {
        this.mAdminConnection = theConnection.admin();
        this.mDb = theConnection.name();
        this.mProperties = HashMultimap.create();
        ((Collection)this.mAdminConnection.get(this.mDb, SecurityOptions.SENSITIVE_PROPERTY_GROUPS)).forEach(sp -> this.mProperties.put((Object)sp.getGroup(), (Object)sp.getIRI()));
        Collection aDefaultProps = (Collection)this.mAdminConnection.get(this.mDb, SecurityOptions.SENSITIVE_PROPERTIES);
        if (!aDefaultProps.isEmpty()) {
            this.mProperties.replaceValues((Object)"", (Iterable)aDefaultProps);
        }
    }

    @Override
    public Set<String> getGroups() {
        return this.mProperties.keySet();
    }

    @Override
    public Set<IRI> getProperties(String theGroup) {
        return ImmutableSet.copyOf((Collection)this.mProperties.get((Object)theGroup));
    }

    @Override
    public boolean removeGroup(String theGroup) {
        if (this.mProperties.containsKey((Object)theGroup)) {
            this.setProperties(theGroup, Collections.emptySet());
            return true;
        }
        return false;
    }

    @Override
    public void setProperties(String theGroup, Set<IRI> theProperties) {
        this.mProperties.replaceValues((Object)theGroup, theProperties);
        if ("".equals(theGroup)) {
            this.mAdminConnection.set(this.mDb, SecurityOptions.SENSITIVE_PROPERTIES, theProperties);
        } else {
            Set aSensitiveProperties = this.mProperties.entries().stream().filter(e -> !"".equals(e.getKey())).map(e -> new SensitiveProperty((String)e.getKey(), (IRI)e.getValue())).collect(Collectors.toSet());
            this.mAdminConnection.set(this.mDb, SecurityOptions.SENSITIVE_PROPERTY_GROUPS, aSensitiveProperties);
        }
    }
}

