/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.ExplainOptions;
import com.google.common.collect.ImmutableMap;
import com.stardog.stark.Value;
import com.stardog.stark.query.Dataset;
import com.stardog.stark.query.Datasets;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.annotation.Nonnull;

public interface Query<T> {
    public static final String NO_ID = "";
    public static final long NO_TIMEOUT = -1L;

    public T execute() throws StardogException;

    public Query<T> parameter(String var1, Value var2);

    public Query<T> parameter(String var1, int var2);

    public Query<T> parameter(String var1, long var2);

    public Query<T> parameter(String var1, float var2);

    public Query<T> parameter(String var1, double var2);

    public Query<T> parameter(String var1, short var2);

    public Query<T> parameter(String var1, boolean var2);

    public Query<T> parameter(String var1, byte var2);

    public Query<T> parameter(String var1, String var2);

    public Query<T> parameter(String var1, Date var2);

    public Query<T> parameter(String var1, GregorianCalendar var2);

    public Query<T> parameter(String var1, URI var2);

    public Query<T> parameter(String var1, Object var2);

    default public Map<String, Value> parameters() {
        return ImmutableMap.of();
    }

    public Map<String, String> hints();

    @Deprecated
    default public String explain(boolean theVerbose) throws StardogException {
        return this.explain(Options.of(ExplainOptions.VERBOSE, (Object)true));
    }

    public String explain(Options var1) throws StardogException;

    default public String explain() throws StardogException {
        return this.explain(Options.of(ExplainOptions.VERBOSE, (Object)false));
    }

    public Query<T> dataset(Dataset var1);

    default public Dataset dataset() {
        return Datasets.NO_DATASET;
    }

    public Query<T> reasoning(boolean var1);

    public boolean isReasoningEnabled();

    public Query<T> schema(String var1);

    public String getSchema();

    public Query<T> id(String var1);

    public String getID();

    default public long timeout() {
        return -1L;
    }

    public Query<T> timeout(long var1);

    public String toString();

    public String queryString();

    default public String baseURI() {
        return "tag:stardog:api:";
    }

    @Nonnull
    public Query<T> hint(@Nonnull String var1, String var2);
}

