/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.base.Pair;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class OptionParser {
    private final Map<Option<?>, Function<Object, ?>> mOptionsMap = Maps.newHashMap();

    OptionParser() {
    }

    <T> void registerOption(Option<T> theOption, Function<Object, T> theFunction) {
        this.mOptionsMap.put(theOption, theFunction);
    }

    private <T> T getValue(Option<T> theOption, Object theValue) throws IllegalArgumentException {
        T result = null;
        if (this.mOptionsMap.containsKey(theOption)) {
            try {
                result = (T)this.mOptionsMap.get(theOption).apply(theValue);
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf((Throwable)e, IllegalArgumentException.class);
                throw new IllegalArgumentException(e);
            }
        }
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException();
    }

    Options getOptions(List<Pair<String, String>> theKeyValuePairs) {
        Options result = Options.create();
        for (Pair<String, String> aPair : theKeyValuePairs) {
            for (Option<?> aRegisteredOption : this.mOptionsMap.keySet()) {
                if (!aRegisteredOption.toString().equals(aPair.first)) continue;
                result.set(aRegisteredOption, this.getValue(aRegisteredOption, aPair.second));
            }
        }
        return result;
    }
}

