/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.entityresolution.protocols.http.client;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.impl.DelegatingConnection;
import com.complexible.stardog.enityresolution.api.EntityResolutionConnection;
import com.complexible.stardog.enityresolution.api.EntityResolutionType;
import com.complexible.stardog.entityresolution.http.shared.EntityResolutionProtocolConstants;
import com.complexible.stardog.protocols.http.JSON;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpConnection;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;

public class EntityResolutionConnectionImpl
extends DelegatingConnection
implements EntityResolutionConnection,
EntityResolutionProtocolConstants {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-type";

    protected EntityResolutionConnectionImpl(Connection connection) {
        super(connection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolveEntities(String targetNamedGraph, String query, String iriFieldName, String computeName, String edgeLabel, EntityResolutionType erType, boolean includeScore, Properties entityResolutionProperties) {
        HttpPost httpPost;
        JsonObject payload = new JsonObject();
        payload.addProperty("stardog.er.target.named.graph", targetNamedGraph);
        payload.addProperty("stardog.er.query", query);
        payload.addProperty("stardog.er.iri.field.name", iriFieldName);
        if (computeName != null) {
            if (computeName.contains(";")) {
                payload.addProperty("stardog.external.compute.props", computeName);
            } else {
                payload.addProperty("stardog.external.compute.name", computeName);
            }
        }
        payload.addProperty("stardog.er.edge.label", edgeLabel);
        payload.addProperty("stardog.er.provider.type", erType.toString());
        payload.addProperty("stardog.er.include.score", Boolean.valueOf(includeScore));
        payload.add("stardog.er.config", (JsonElement)JSON.toJson((Object)entityResolutionProperties));
        HttpConnection httpConnection = (HttpConnection)super.getConnection();
        String schema = httpConnection.getSchema();
        Preconditions.checkState((boolean)httpConnection.isOpen(), (Object)"Connection is closed");
        HttpClient httpClient = httpConnection.getClient();
        Object httpURL = httpClient.url("entityresolution");
        if (schema == null) {
            httpPost = new HttpPost((String)httpURL);
        } else {
            httpURL = (String)httpURL + "/reasoning";
            try {
                URI uri = new URIBuilder((String)httpURL).addParameter("reasoning", "true").addParameter("schema", schema).build();
                httpPost = new HttpPost(uri);
            }
            catch (URISyntaxException theE) {
                throw new RuntimeException(theE);
            }
        }
        HttpEntity httpEntity = null;
        try {
            StringEntity stringEntity = new StringEntity(payload.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setHeader(ACCEPT, (Object)"application/json");
            httpPost.setHeader(CONTENT_TYPE, (Object)"application/json");
            CloseableHttpResponse httpResponse = httpClient.execute((ClassicHttpRequest)httpPost);
            httpEntity = httpResponse.getEntity();
            if (httpEntity == null) return;
        }
        catch (Exception e) {
            try {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (httpEntity == null) throw throwable;
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return;
    }
}

