/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.reasoning;

import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.complexible.common.base.Options;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.api.reasoning.ReasoningConnection;
import com.complexible.stardog.api.reasoning.SchemaManager;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.complexible.stardog.reasoning.ExpressionWriter;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.stardog.stark.io.RDFFormat;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@Command(name="schema", description="Management of reasoning schemas.", examples={"* Export the default schema of the database in human-friendly format:", "    $ stardog reasoning schema myDB", "", "* Export the default schema of the database without syntax highlighting:", "    $ stardog reasoning schema --no-color myDB", "", "* Export the default schema of the database in turtle format:", "    $ stardog reasoning schema -f turtle myDB", "", "* Export the given named schema:", "    $ stardog reasoning schema --show mySchema myDB", "", "* Set the named graphs for the default schema:", "    $ stardog reasoning schema --add default --graphs :myGraph http://example.com/anotherGraph -- myDB", "", "* Add a new named schema to the database for the given named graphs:", "    $ stardog reasoning schema --add mySchema --graphs :myGraph http://example.com/anotherGraph -- myDB", "", "* Remove a named schema from the database:", "    $ stardog reasoning schema --remove mySchema myDB :myGraph", "", "* List all the named schemas:", "    $ stardog reasoning schema --list myDB"})
public final class SchemaCmd
extends ConnectionCommand<Void> {
    @Option(description="Result format for output [NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD]", name={"-f", "--format"}, title="resultFormat")
    public final String mFormat;
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https.", title={"database"})
    public String mDbName;
    @Option(name={"--no-color"}, description="Do not use ANSI syntax highlighting in the output. Note that syntax highlighting is used only when an output format is not provided so this option is not needed if you specify an output format.", title="", arity=0)
    public boolean mNoColors = false;
    @Option(name={"-g", "--graphs", "--named-graphs"}, title="named graph(s)", description="Named graph(s) to associate with a schema. Only valid with --add option", arity=0x7FFFFFFF)
    public List<String> mAddGraphs = Lists.newArrayList();
    @Option(name={"-l", "--list"}, description="Lists the names of all schemas in this database", arity=0)
    public boolean isList = false;
    @Option(name={"-a", "--add"}, title="schemaName", description="Adds a new reasoning schema with the given name. The named graphs for the schema should be provided with the {-g, --graphs} option. If the schema already exists its named graph setting wil lbe overridden.")
    protected String mAddSchema = null;
    @Option(name={"-s", "--show"}, title="schemaName", description="Exports the contents of the specified schema with the given name.")
    protected String mShowSchema;
    @Option(name={"-r", "--remove"}, title="schemaName", description="Removes the reasoning schema with the given name.")
    protected String mRemoveSchema = null;

    @Inject
    public SchemaCmd(PasswordReader theReader) {
        super(theReader);
        this.mFormat = null;
    }

    protected String connectionString() {
        return this.mDbName;
    }

    protected String getReasoningSchema() {
        return this.mShowSchema != null ? this.mShowSchema : "default";
    }

    public void execute(Connection theConn) throws StardogException {
        this.validateCommands();
        ReasoningConnection aConn = (ReasoningConnection)theConn.as(ReasoningConnection.class);
        NamespacesInfo aNamespaces = aConn.namespaces();
        SchemaManager aMgr = aConn.getSchemaManager();
        if (this.isList) {
            List aSchemas = Ordering.usingToString().sortedCopy((Iterable)aMgr.getSchemas());
            aSchemas.remove("default");
            aSchemas.add(0, "default");
            TurtleValueWriter aWriter = new TurtleValueWriter((Iterable)aNamespaces);
            String[] aColumns = new String[]{"Schema", "Graphs"};
            TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, aColumns);
            for (String aDatabase : aSchemas) {
                Object[] objectArray = new Object[2];
                objectArray[0] = aDatabase;
                objectArray[1] = FluentIterable.from((Iterable)aMgr.getSchemaGraphs(aDatabase)).transform(arg_0 -> ((TurtleValueWriter)aWriter).write(arg_0)).join(Joiner.on((String)", "));
                Object[] aRow = objectArray;
                aTable.addRow(aRow);
            }
            aTable.output();
        } else if (this.mAddSchema != null) {
            aMgr.setSchemaGraphs(this.mAddSchema, CliUtil.readIRIs(this.mAddGraphs, (Iterable)aNamespaces));
            System.out.println(SchemaCmd.get((String)"schema.added", (Object[])new Object[]{this.mAddSchema}));
        } else if (this.mRemoveSchema != null) {
            aMgr.removeSchema(this.mRemoveSchema);
            System.out.println(SchemaCmd.get((String)"schema.removed", (Object[])new Object[]{this.mRemoveSchema}));
        } else {
            Iterable aSchema = aConn.exportSchema();
            if (Strings.isNullOrEmpty((String)this.mFormat)) {
                String aOutput = new ExpressionWriter((Iterable)aNamespaces, Options.of((com.complexible.common.base.Option)OntologyWriterOptions.ANSI_COLOR, (Object)(!this.mNoColors ? 1 : 0))).write(aSchema).toString();
                System.out.println(aOutput);
            } else {
                RDFFormat aFormat = CliUtil.getFormat((String)this.mFormat);
                if (aFormat == null) {
                    System.out.println(SchemaCmd.get((String)"query.error.noformat", (Object[])new Object[]{this.mFormat, "NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD"}));
                    return;
                }
                CliUtil.writeGraph((Iterable)aSchema, (RDFFormat)aFormat, (Iterable)aNamespaces, (OutputStream)System.out);
            }
        }
    }

    private void validateCommands() {
        ArrayList commands = Lists.newArrayList();
        if (this.mAddSchema != null) {
            commands.add("--add");
        }
        if (this.mRemoveSchema != null) {
            commands.add("--remove");
        }
        if (this.mShowSchema != null) {
            commands.add("--show");
        }
        if (this.isList) {
            commands.add("--list");
        }
        if (commands.size() > 1) {
            throw new CliException(SchemaCmd.get((String)"schema.multiple.commands", (Object[])new Object[]{commands}));
        }
        if (this.mAddSchema != null) {
            if (this.mAddGraphs.isEmpty()) {
                throw new CliException(SchemaCmd.get((String)"schema.graphs.missing", (Object[])new Object[]{commands}));
            }
        } else if (!this.mAddGraphs.isEmpty()) {
            throw new CliException(SchemaCmd.get((String)"schema.graphs.unexpected", (Object[])new Object[]{commands}));
        }
    }
}

