/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.reasoning;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.reasoning.ReasoningConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.reasoning.ReasoningConnectionCommand;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.stardog.stark.Values;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Command(name="consistency", description="Checks the logical consistency of database.", examples={"* Check the consistency of the database:", "    $ stardog reasoning consistency myDb", "", "* Check the consistency of a set of specific named graphs:", "    $ stardog reasoning consistency --named-graphs http://example.org/graph1 http://example.org/graph2 -- myDB"})
public final class IsConsistent
extends ReasoningConnectionCommand {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https.", title={"database"})
    public String mDbName;
    @Option(name={"-g", "--named-graph", "--named-graphs"}, arity=0x7FFFFFFF, description="The list of named graphs to check the consistency of; if none are specified, consistency of the entire database is checked.", title="contexts")
    public List<String> mContexts;

    @Inject
    public IsConsistent(PasswordReader theReader) {
        super(theReader);
    }

    protected String connectionString() {
        return this.mDbName;
    }

    @Override
    protected void execute(ReasoningConnection theConn) throws StardogException {
        boolean aIsContexts;
        HashSet aGraphs = Sets.newHashSet();
        boolean bl = aIsContexts = this.mContexts != null && !this.mContexts.isEmpty();
        if (aIsContexts) {
            for (String context : this.mContexts) {
                try {
                    aGraphs.add(Values.iri((String)context));
                }
                catch (Exception e) {
                    System.out.println(IsConsistent.get((String)"consistency.error.context.invalid", (Object[])new Object[]{context}));
                }
            }
        }
        boolean aConsistent = aGraphs.isEmpty() ? theConn.isConsistent() : theConn.isConsistent((Collection)aGraphs);
        System.out.println(IsConsistent.get((String)"consistency.result", (Object[])new Object[]{aConsistent ? 1 : 0}));
    }
}

