/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.reasoning;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.reasoning.ExpressionWriter;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofWriter;
import com.google.common.collect.Iterables;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriters;
import java.io.OutputStream;
import java.util.Collections;

public final class ExplanationCliUtil {
    public static final RDFFormat TEXT_PROOF_FORMAT = RDFFormats.register((String)"proof/text", (IRI)Values.iri((String)"tag:stardog:proof:text"), Collections.singletonList("proof/text"), Collections.singletonList("ptxt"));
    public static final RDFFormat TREE_PROOF_FORMAT = RDFFormats.register((String)"proof/tree", (IRI)Values.iri((String)"tag:stardog:proof:tree"), Collections.singletonList("proof/tree"), Collections.singletonList("tree"));

    public static RDFFormat getExplanationFormat(String theFormat) {
        if (theFormat == null || theFormat.equalsIgnoreCase("TREE")) {
            return TREE_PROOF_FORMAT;
        }
        if (theFormat.equalsIgnoreCase("TEXT")) {
            return TEXT_PROOF_FORMAT;
        }
        return CliUtil.getFormat((String)theFormat, null);
    }

    public static void writeProofs(Iterable<Proof> theProofs, RDFFormat theFormat, Iterable<Namespace> theNamespaces) throws StardogException {
        if (theFormat == TEXT_PROOF_FORMAT) {
            for (Proof aProof : theProofs) {
                System.out.println(ExpressionWriter.toString(theNamespaces, (Iterable)aProof.getStatements()));
            }
        } else if (theFormat == TREE_PROOF_FORMAT) {
            for (Proof aProof : theProofs) {
                System.out.println(ProofWriter.toString(theNamespaces, (Proof)aProof));
            }
        } else {
            Iterable aStmts = Iterables.concat((Iterable)Iterables.transform(theProofs, theProof -> theProof.getStatements()));
            RDFWriters.write((OutputStream)System.out, (RDFFormat)theFormat, (Iterable)aStmts, (Iterable)new NamespacesImpl(theNamespaces));
        }
    }
}

