/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.reasoning;

import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.reasoning.ReasoningConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.reasoning.ExplanationCliUtil;
import com.complexible.stardog.cli.reasoning.ReasoningConnectionCommand;
import com.complexible.stardog.reasoning.ReasoningUtils;
import com.complexible.stardog.reasoning.StardogExplainer;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.stardog.stark.Axiom;
import com.stardog.stark.Axioms;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Command(name="explain", description="Provide the explanation for an inference or inconsistency.", discussion="Returns an explanation for the inference in the given file or for the inconsistency of the database. If provided, the input file should contain a single axiom. The explanation output is the minimal set of asserted statements in the database that are needed for the inference to hold. The statements in the explanation can be rendered in any RDF format but by default they will be rendered in a concise, human-readable, text format. There is also a proof tree format where the statements are rendered in hierarchical structure. Nodes in the proof tree are grouped under inferred statements that make it easier to understand the explanation.", examples={"* Show a single explanation of an inferred statement:", "    $ stardog reasoning explain myDb \"ex:JohnDoe a ont:Person\"", "", "* Show up to 10 explanations along with named graph info and merge common explanations:", "    $ stardog reasoning explain -l 10 --merge --print-named-graphs myDb \":Employee rdfs:subClassOf :Person\"", "", "* Read axiom to explain from a file and output the explanation in Turtle format:", "    $ stardog reasoning explain -o turtle myDb axiomToExplain.ttl"})
final class ExplainInference
extends ReasoningConnectionCommand {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The subsequent argument is the inference to explain. This can either be a file name or an RDF string. When Turtle string is given as an argument the prefixes stored in the database can be omitted.", title={"database", "input"})
    public List<String> mArgs;
    @Option(name={"-i", "--inconsistency"}, description="Explain inconsistency of the database")
    public boolean mInconsistency = false;
    @Option(name={"--print-named-graphs"}, description="Retrieves and prints the source named graphs for triples in the explanation. If this option is enabled, the output format should support named graphs too.")
    public boolean mNamedGraphs = false;
    @Option(name={"-l", "--limit"}, title="limit", description="Limits the number of explanation returned. The default limit is 1. Note that, when a RDF output format is selected and the limit is set to higher than 1, there is no way to distinguish which triple in the output belongs to which explanation. In TEXT and TREE outputs there will be an empty line separating different explanations.")
    public int mLimit = 1;
    @Option(name={"-m", "--merge"}, description="Merge proof trees with common nodes. This works only with TREE format and when the limit is is set higher than 1.")
    public boolean mMerge = false;
    @Option(name={"-f", "--format"}, description="Input data format: NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD", title="format")
    public String mRdfFormat;
    @Option(name={"-o", "--output-format"}, description="Output format for the explanation: [TEXT, TREE, NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD]. The default format is 'TEXT' where the explanation is rendered in a concise, human-readable format.", title="format")
    public String outputRdfFormat;
    protected String mInput;
    protected String mDbName;

    @Inject
    public ExplainInference(PasswordReader theReader) {
        super(theReader);
    }

    protected final String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                this.mInput = this.mArgs.get(1);
            }
        }
        return this.mDbName;
    }

    @Override
    protected void execute(ReasoningConnection theConn) throws StardogException {
        try {
            StardogExplainer aExplainer;
            Namespaces aNamespaces = CliUtil.namespaces((Connection)theConn);
            if (this.mInconsistency) {
                aExplainer = theConn.explainInconsistency();
            } else {
                if (this.mInput == null) {
                    throw new CliException(ExplainInference.get((String)"explain.inference.error.nofile", (Object[])new Object[0]));
                }
                Set aInputGraph = CliUtil.readGraph((String)this.mInput, (String)this.mRdfFormat, (Iterable)aNamespaces);
                this.assertSingleAxiom(aInputGraph);
                Axiom aInputExpression = Axioms.fromStatements((Iterable)aInputGraph);
                aExplainer = theConn.explain(aInputExpression);
            }
            RDFFormat aOutputFormat = ExplanationCliUtil.getExplanationFormat(this.outputRdfFormat);
            if (this.mNamedGraphs || aOutputFormat != null && RDFFormats.supportsContexts((RDFFormat)aOutputFormat)) {
                aExplainer.computeNamedGraphs();
            }
            if (this.mMerge) {
                aExplainer.mergeExplanations();
            }
            aExplainer.countLimit(this.mLimit);
            Iterable aExplanations = aExplainer.proofs();
            if (Iterables.isEmpty((Iterable)aExplanations)) {
                System.out.println(this.mInconsistency ? ExplainInference.get((String)"explain.inference.error.consistent", (Object[])new Object[0]) : ExplainInference.get((String)"explain.inference.error.inference.invalid", (Object[])new Object[0]));
                return;
            }
            ExplanationCliUtil.writeProofs(aExplanations, aOutputFormat, (Iterable<Namespace>)aNamespaces);
        }
        catch (IllegalArgumentException e) {
            throw new CliException(ExplainInference.get((String)"cmd.error.unsupported.format", (Object[])new Object[]{e.getMessage(), "NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD"}));
        }
        catch (Exception e) {
            throw new CliException((Throwable)e);
        }
    }

    private void assertSingleAxiom(Set<Statement> aGraph) throws CliException {
        int aAxiomCount = ExplainInference.getAxiomCount(aGraph);
        if (aAxiomCount == 0) {
            throw new CliException(ExplainInference.get((String)"explain.inference.error.axioms.none", (Object[])new Object[0]));
        }
        if (aAxiomCount > 1) {
            throw new CliException(ExplainInference.get((String)"explain.inference.error.axioms.multiple", (Object[])new Object[0]));
        }
    }

    private static int getAxiomCount(Set<Statement> aGraph) {
        Set aAxioms = ReasoningUtils.convertToAxioms(aGraph);
        return aGraph.size() - Iterators.size((Iterator)Iterators.filter(aAxioms.iterator(), Declaration.class));
    }
}

