/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io;

import com.complexible.common.base.Options;
import com.complexible.common.util.ServiceLoaders;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BooleanQueryResult;
import com.stardog.stark.query.QueryResult;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.io.BooleanQueryResultWriter;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class QueryResultWriters {
    private static final Set<QueryResultWriterFactory> WRITERS = new HashSet<QueryResultWriterFactory>();

    public static void write(@Nonnull QueryResult theResult, @Nonnull Path thePath, @Nonnull QueryResultFormat theQueryResultFormat) throws IOException, ResultWritingFailed {
        if (theResult instanceof SelectQueryResult) {
            QueryResultWriters.write((SelectQueryResult)theResult, thePath, theQueryResultFormat);
            return;
        }
        if (theResult instanceof BooleanQueryResult) {
            QueryResultWriters.write((BooleanQueryResult)theResult, thePath, theQueryResultFormat);
            return;
        }
        throw new IllegalArgumentException("Unsupported result type");
    }

    public static void write(@Nonnull BooleanQueryResult theResult, @Nonnull Path thePath, @Nonnull QueryResultFormat theQueryResultFormat) throws IOException, ResultWritingFailed {
        try (FileOutputStream aOut = new FileOutputStream(thePath.toFile());){
            QueryResultWriters.write(theResult, (OutputStream)aOut, theQueryResultFormat);
        }
    }

    public static void write(@Nonnull BooleanQueryResult theResult, @Nonnull OutputStream theOutput, @Nonnull QueryResultFormat theQueryResultFormat) throws IOException, ResultWritingFailed {
        BooleanQueryResultWriter aWriter = QueryResultWriters.to(theOutput, theQueryResultFormat).map(BooleanQueryResultWriter.class::cast).orElse(null);
        if (aWriter == null) {
            throw new IllegalArgumentException("Unknown or unsupported result format");
        }
        aWriter.start();
        aWriter.handle(theResult.booleanValue());
        aWriter.end();
    }

    public static void write(@Nonnull SelectQueryResult theResult, @Nonnull Path thePath, @Nonnull QueryResultFormat theQueryResultFormat) throws IOException, ResultWritingFailed {
        try (FileOutputStream aOut = new FileOutputStream(thePath.toFile());){
            QueryResultWriters.write(theResult, (OutputStream)aOut, theQueryResultFormat);
        }
    }

    public static void write(@Nonnull SelectQueryResult theResult, @Nonnull OutputStream theOutput, @Nonnull QueryResultFormat theQueryResultFormat) throws IOException, ResultWritingFailed {
        SelectQueryResultWriter aWriter = QueryResultWriters.to(theOutput, theQueryResultFormat).map(SelectQueryResultWriter.class::cast).orElse(null);
        if (aWriter == null) {
            throw new IllegalArgumentException("Unknown or unsupported result format");
        }
        QueryResultWriters.write(theResult, aWriter);
    }

    public static void write(@Nonnull SelectQueryResult theResult, @Nonnull SelectQueryResultWriter theWriter) throws ResultWritingFailed {
        try (SelectQueryResult aResult = theResult;){
            theWriter.start();
            theWriter.variables(theResult.variables());
            theResult.stream().forEach(theWriter::handle);
            theWriter.end();
        }
    }

    public static Optional<QueryResultWriter<BindingSet>> to(@Nonnull OutputStream theOutput, @Nonnull QueryResultFormat theFormat) {
        return QueryResultWriters.to(theOutput, theFormat, WriterOptions.defaults());
    }

    public static Optional<BooleanQueryResultWriter> to(@Nonnull QueryResultFormat theFormat, @Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
        return WRITERS.stream().filter(f -> f.format().equals(theFormat)).map(f -> f.create(theOutputStream, theOptions)).map(BooleanQueryResultWriter.class::cast).findFirst();
    }

    public static Optional<QueryResultWriter<BindingSet>> to(@Nonnull OutputStream theOutput, @Nonnull QueryResultFormat theFormat, @Nonnull Options theOptions) {
        return WRITERS.stream().filter(theParser -> theParser.format().equals(theFormat)).map(theFactory -> theFactory.create(theOutput, theOptions)).findFirst();
    }

    private QueryResultWriters() {
        throw new AssertionError();
    }

    static {
        ServiceLoaders.instancesOf(QueryResultWriterFactory.class).forEach(WRITERS::add);
        WRITERS.forEach(p -> QueryResultFormats.register(p.format()));
    }
}

