/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io;

import com.complexible.common.base.Options;
import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.util.ServiceLoaders;
import com.google.common.base.Preconditions;
import com.stardog.stark.query.BooleanQueryResult;
import com.stardog.stark.query.QueryResult;
import com.stardog.stark.query.QueryResultBuilder;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.impl.BooleanQueryResultHandlerImpl;
import com.stardog.stark.query.impl.SelectQueryResultHandlerImpl;
import com.stardog.stark.query.io.AsyncSelectQueryResult;
import com.stardog.stark.query.io.BooleanQueryResultParser;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultParser;
import com.stardog.stark.query.io.QueryResultParserOptions;
import com.stardog.stark.query.io.SelectQueryResultParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class QueryResultParsers {
    private static final Set<QueryResultParser> PARSERS = new HashSet<QueryResultParser>();

    @Nonnull
    public static Optional<QueryResultParser> forFormat(@Nonnull QueryResultFormat theFormat) {
        Preconditions.checkNotNull((Object)theFormat);
        return PARSERS.stream().filter(theParser -> theParser.format().equals(theFormat)).findFirst();
    }

    @Nonnull
    public static Optional<SelectQueryResultParser> forSelectFormat(@Nonnull QueryResultFormat theFormat) {
        Preconditions.checkNotNull((Object)theFormat);
        return PARSERS.stream().filter(SelectQueryResultParser.class::isInstance).map(SelectQueryResultParser.class::cast).filter(theParser -> theParser.format().equals(theFormat)).findFirst();
    }

    @Nonnull
    public static Optional<BooleanQueryResultParser> forBooleanFormat(@Nonnull QueryResultFormat theFormat) {
        Preconditions.checkNotNull((Object)theFormat);
        return PARSERS.stream().filter(BooleanQueryResultParser.class::isInstance).map(BooleanQueryResultParser.class::cast).filter(theParser -> theParser.format().equals(theFormat)).findFirst();
    }

    @Nonnull
    public static SelectQueryResult readSelect(@Nonnull Path thePath) throws IOException {
        QueryResultFormat aFormat = QueryResultFormats.selectFormats().forFile(thePath).orElse(null);
        if (aFormat == null) {
            throw new IllegalArgumentException("Unknown or unsupported file type");
        }
        SelectQueryResultParser aParser = QueryResultParsers.forSelectFormat(aFormat).orElse(null);
        if (aParser == null) {
            throw new IllegalArgumentException("No parser supports files of the given format");
        }
        SelectQueryResultHandlerImpl aHandler = new SelectQueryResultHandlerImpl();
        try (FileInputStream aInputStream = new FileInputStream(thePath.toFile());){
            aParser.parse(aInputStream, aHandler);
        }
        return aHandler.result();
    }

    @Nonnull
    public static SelectQueryResult readSelect(@Nonnull InputStream theStream, @Nonnull QueryResultFormat theFormat) throws IOException {
        return (SelectQueryResult)QueryResultParsers.read(theStream, QueryResultParsers.getResultsParser(theFormat), QueryResultParserOptions.defaults(), new SelectQueryResultHandlerImpl());
    }

    public static SelectQueryResult readSelectAsync(@Nonnull InputStream theStream, @Nonnull ExecutorService theExecutorService, @Nonnull QueryResultFormat theFormat, @Nonnull int batchSize, @Nonnull CancelCheck cancelCheck, @Nonnull Consumer<Boolean> onClose, @Nonnull Function<Exception, RuntimeException> onError) {
        return new AsyncSelectQueryResult(theStream, QueryResultParsers.getResultsParser(theFormat), theExecutorService, batchSize, cancelCheck, onClose, onError);
    }

    private static QueryResultParser getResultsParser(QueryResultFormat theFormat) {
        return QueryResultParsers.forFormat(theFormat).orElseThrow(() -> new IllegalArgumentException("Unknown result format: " + String.valueOf(theFormat)));
    }

    public static boolean readBoolean(@Nonnull InputStream theStream, @Nonnull QueryResultFormat theFormat) throws IOException {
        return ((BooleanQueryResult)QueryResultParsers.read(theStream, QueryResultParsers.getResultsParser(theFormat), QueryResultParserOptions.defaults(), new BooleanQueryResultHandlerImpl())).booleanValue();
    }

    @Nonnull
    public static <T> QueryResult<T> read(@Nonnull Path thePath, @Nonnull QueryResultFormat theFormat, @Nonnull Options theOptions, @Nonnull QueryResultBuilder<T> theHandler) throws IOException {
        try (InputStream aStream = Files.newInputStream(thePath, new OpenOption[0]);){
            QueryResult<T> queryResult = QueryResultParsers.read(aStream, theFormat, theOptions, theHandler);
            return queryResult;
        }
    }

    @Nonnull
    public static <T> QueryResult<T> read(@Nonnull InputStream theStream, @Nonnull QueryResultFormat theFormat, @Nonnull Options theOptions, @Nonnull QueryResultBuilder<T> theHandler) throws IOException {
        return QueryResultParsers.read(theStream, QueryResultParsers.getResultsParser(theFormat), theOptions, theHandler);
    }

    @Nonnull
    public static <T> QueryResult<T> read(@Nonnull Path thePath, @Nonnull QueryResultParser theParser, @Nonnull Options theOptions, @Nonnull QueryResultBuilder<T> theHandler) throws IOException {
        try (FileInputStream aStream = new FileInputStream(thePath.toFile());){
            QueryResult<T> queryResult = QueryResultParsers.read((InputStream)aStream, theParser, theOptions, theHandler);
            return queryResult;
        }
    }

    @Nonnull
    public static <T> QueryResult<T> read(@Nonnull InputStream theStream, @Nonnull QueryResultParser theParser, @Nonnull Options theOptions, @Nonnull QueryResultBuilder<T> theHandler) throws IOException {
        theParser.parse(theStream, theHandler, theOptions);
        return theHandler.result();
    }

    private QueryResultParsers() {
        throw new AssertionError();
    }

    static {
        ServiceLoaders.instancesOf(QueryResultParser.class).forEach(PARSERS::add);
        PARSERS.forEach(p -> QueryResultFormats.register(p.format()));
    }
}

