/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.stardog.stark.IRI;
import com.stardog.stark.Values;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.FileFormatImpl;
import com.stardog.stark.io.SupportedFileFormats;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultParser;
import com.stardog.stark.query.io.QueryResultParsers;
import com.stardog.stark.query.io.QueryResultWriters;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class QueryResultFormats {
    public static final QueryResultFormat XML = new QueryResultFormatImpl("SPARQL/XML", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_XML"), (List<String>)ImmutableList.of((Object)"application/sparql-results+xml", (Object)"application/xml"), (List<String>)ImmutableList.of((Object)"srx", (Object)"xml"));
    public static final QueryResultFormat XML_BOOLEAN = new QueryResultFormatImpl("SPARQL/XML Boolean", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_XML"), (List<String>)ImmutableList.of((Object)"application/sparql-results+xml", (Object)"application/xml"), (List<String>)ImmutableList.of((Object)"srx", (Object)"xml"));
    public static final QueryResultFormat JSON = new QueryResultFormatImpl("SPARQL/JSON", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_JSON"), (List<String>)ImmutableList.of((Object)"application/sparql-results+json", (Object)"application/json"), (List<String>)ImmutableList.of((Object)"srj", (Object)"json"));
    public static final QueryResultFormat JSON_BOOLEAN = new QueryResultFormatImpl("SPARQL/JSON", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_JSON"), (List<String>)ImmutableList.of((Object)"application/sparql-results+json", (Object)"application/json"), (List<String>)ImmutableList.of((Object)"srj", (Object)"json"));
    public static final QueryResultFormat TSV = new QueryResultFormatImpl("SPARQL/TSV", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_TSV"), (List<String>)ImmutableList.of((Object)"text/tab-separated-values", (Object)"text/tsv"), (List<String>)ImmutableList.of((Object)"tsv"));
    public static final QueryResultFormat CSV = new QueryResultFormatImpl("SPARQL/CSV", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_CSV"), (List<String>)ImmutableList.of((Object)"text/csv"), (List<String>)ImmutableList.of((Object)"csv"));
    public static final QueryResultFormat TEXT = new QueryResultFormatImpl("TEXT", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_TEXT"), (List<String>)ImmutableList.of((Object)"text/boolean"), (List<String>)ImmutableList.of((Object)"txt"), Charsets.US_ASCII);
    public static final QueryResultFormat TEXT_TABLE = new QueryResultFormatImpl("TEXT", Values.iri((String)"urn:stardog:query:io:text"), (List<String>)ImmutableList.of((Object)"text/plain"), (List<String>)ImmutableList.of((Object)"txt"));
    public static final QueryResultFormat BINARY = new QueryResultFormatImpl("BINARY", Values.iri((String)"http://www.w3.org/ns/formats/SPARQL_Results_BINARY"), (List<String>)ImmutableList.of((Object)"application/x-binary-rdf-results-table"), (List<String>)ImmutableList.of((Object)"bqr"));
    private static final Set<QueryResultFormat> SELECT_FORMATS = new HashSet<QueryResultFormat>();
    private static final SupportedFileFormats<QueryResultFormat> FORMATS = new SupportedFileFormats();

    @Nonnull
    public static Optional<QueryResultFormat> forFile(@Nonnull Path thePath) {
        return FORMATS.forFile(thePath);
    }

    @Nonnull
    public static Optional<QueryResultFormat> forFileName(@Nonnull String thePath) {
        return FORMATS.forFileName(thePath);
    }

    @Nonnull
    public static Optional<QueryResultFormat> forMime(@Nonnull String theMime) {
        return FORMATS.forMime(theMime);
    }

    @Nonnull
    public static Optional<QueryResultFormat> forMimeSelect(@Nonnull String theMime) {
        return QueryResultFormats.selectFormats().forMime(theMime);
    }

    @Nonnull
    public static SupportedFileFormats<QueryResultFormat> selectFormats() {
        return FORMATS.only(SELECT_FORMATS::contains);
    }

    @Nonnull
    public static SupportedFileFormats<QueryResultFormat> booleanFormats() {
        return FORMATS.only(f -> !SELECT_FORMATS.contains(f));
    }

    @Nonnull
    public static Optional<QueryResultFormat> forMimeBoolean(@Nonnull String theMime) {
        return QueryResultFormats.booleanFormats().forMime(theMime);
    }

    public static void register(QueryResultFormat theFormat) {
        FORMATS.add((FileFormat)theFormat);
        QueryResultParsers.forSelectFormat(theFormat).map(QueryResultParser::format).ifPresent(SELECT_FORMATS::add);
    }

    public static QueryResultFormat register(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
        QueryResultFormatImpl aFormat = new QueryResultFormatImpl(theName, theId, theMimetypes, theFileExtensions, Charsets.UTF_8);
        QueryResultFormats.register(aFormat);
        return aFormat;
    }

    private QueryResultFormats() {
        throw new AssertionError();
    }

    static {
        QueryResultParsers.forFormat(CSV);
        QueryResultWriters.to(ByteStreams.nullOutputStream(), CSV);
        FORMATS.forEach(fmt -> QueryResultParsers.forSelectFormat(fmt).map(QueryResultParser::format).ifPresent(SELECT_FORMATS::add));
        SELECT_FORMATS.add(TEXT_TABLE);
    }

    private static final class QueryResultFormatImpl
    extends FileFormatImpl
    implements QueryResultFormat {
        private final IRI mId;
        private final Charset mCharset;

        public QueryResultFormatImpl(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
            this(theName, theId, theMimetypes, theFileExtensions, Charsets.UTF_8);
        }

        public QueryResultFormatImpl(@Nonnull String theName, @Nonnull IRI theId, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions, @Nonnull Charset theCharset) {
            super(theName, theMimetypes, theFileExtensions);
            this.mId = theId;
            this.mCharset = theCharset;
        }

        @Nonnull
        public Charset charset() {
            return this.mCharset;
        }
    }
}

