/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.HandlerBackedIterator;
import com.complexible.common.cancellation.CancelCheck;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.QueryResultParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.mutable.MutableObject;

public class AsyncSelectQueryResult
extends CloseableIterator.AbstractCloseableIterator<BindingSet>
implements SelectQueryResult {
    private final MutableObject<List<String>> mVars = new MutableObject();
    private final CloseableIterator<BindingSet> mBindings;
    private final Consumer<Boolean> mOnClose;
    private final Function<Exception, RuntimeException> mOnError;
    private boolean mEndOfData = false;

    public AsyncSelectQueryResult(InputStream input, QueryResultParser<SelectQueryResultHandler> parser, ExecutorService execService, int batchSize, CancelCheck cancelCheck, Consumer<Boolean> onClose, Function<Exception, RuntimeException> onError) {
        this.mOnClose = onClose;
        this.mOnError = onError;
        this.mBindings = new HandlerBackedIterator(handler -> {
            try {
                parser.parse(input, new DelegatingHandler(handler, arg_0 -> this.mVars.setValue(arg_0)));
            }
            catch (HandlerBackedIterator.ProducerFinished producerFinished) {
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
        }, execService, cancelCheck, batchSize);
    }

    public void close() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mBindings, () -> this.mOnClose.accept(this.mEndOfData)});
    }

    protected BindingSet computeNext() {
        try {
            if (this.mBindings.hasNext()) {
                return (BindingSet)this.mBindings.next();
            }
            this.mEndOfData = true;
        }
        catch (Exception e) {
            throw this.mOnError.apply(e);
        }
        return (BindingSet)this.endOfData();
    }

    @Nonnull
    public List<String> variables() {
        try {
            boolean bl = this.mBindings.hasNext();
        }
        catch (Exception e) {
            throw this.mOnError.apply(e);
        }
        return (List)this.mVars.getValue();
    }

    private static final class DelegatingHandler
    implements SelectQueryResultHandler {
        final Consumer<BindingSet> mHandler;
        final Consumer<List<String>> mSetVars;

        DelegatingHandler(Consumer<BindingSet> handler, Consumer<List<String>> setVars) {
            this.mHandler = handler;
            this.mSetVars = setVars;
        }

        public void variables(@Nonnull List<String> theVars) {
            this.mSetVars.accept(theVars);
        }

        public void links(@Nonnull List<String> theLinks) {
        }

        public void handle(@Nonnull BindingSet bindings) {
            this.mHandler.accept(bindings);
        }

        public void start() {
        }

        public void end() {
        }
    }
}

